/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.ExceptionAnalyzer;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.glassfish.api.admin.AuthenticationException;
import org.glassfish.api.admin.CommandException;

public class DASUtils {
    private static final System.Logger LOG = System.getLogger(DASUtils.class.getName());

    private DASUtils() {
    }

    public static boolean pingDASQuietly(ProgramOptions programOpts, Environment env) {
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
            return true;
        }
        catch (AuthenticationException aex) {
            return true;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.DEBUG, "Communication with the server failed. " + ex.getMessage());
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                return false;
            }
            if (ea.getFirstInstanceOf(UnknownHostException.class) != null) {
                return false;
            }
            return ea.getFirstInstanceOf(IOException.class) != null;
        }
    }

    public static Error pingDASWithAuth(ProgramOptions programOpts, Environment env) throws CommandException {
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
        }
        catch (AuthenticationException aex) {
            return Error.AUTHENTICATION;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Communication with the server failed. " + ex.getMessage());
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                return Error.CONNECTION;
            }
            if (ea.getFirstInstanceOf(UnknownHostException.class) != null) {
                return Error.CONNECTION;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                return Error.IO;
            }
            return Error.UNKNOWN;
        }
        return Error.NONE;
    }

    public static enum Error {
        NONE,
        AUTHENTICATION,
        CONNECTION,
        IO,
        UNKNOWN;

    }
}

