/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import org.glassfish.main.jul.handler.GlassFishLogHandler;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

abstract class LoggingPumpThread
extends Thread {
    private final LogRecordBuffer buffer;

    protected LoggingPumpThread(String threadName, LogRecordBuffer buffer) {
        super(threadName);
        this.setDaemon(true);
        this.setPriority(10);
        this.buffer = buffer;
    }

    protected abstract int getFlushFrequency();

    protected abstract boolean logRecord(GlassFishLogRecord var1);

    protected abstract void flushOutput();

    @Override
    public final void run() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, () -> "Logging pump for " + String.valueOf(this.buffer) + " started.");
        while (!this.isInterrupted()) {
            try {
                this.publishBatchFromBuffer();
            }
            catch (Exception e) {
                GlassFishLoggingTracer.error(this.getClass(), "Log record not published.", e);
            }
        }
    }

    private void publishBatchFromBuffer() {
        if (!this.logRecord(this.buffer.pollOrWait())) {
            return;
        }
        if (this.getFlushFrequency() > 1) {
            for (int i = 1; i < this.getFlushFrequency() && this.logRecord(this.buffer.poll()); ++i) {
            }
        }
        this.flushOutput();
    }
}

