/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="http")
@PerLookup
public class HTTPInputArchive
extends AbstractReadableArchive {
    private URI archiveURI = null;
    private URL archiveURL = null;
    private Manifest cachedManifest = null;
    private int cachedArchiveSize = -2;
    private Collection<String> cachedEntryNames = null;
    private Boolean exists;

    public InputStream getEntry(String name) throws IOException {
        try {
            return this.entryURL(name).openStream();
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private URL entryURL(String name) throws MalformedURLException {
        if (((String)name).charAt(0) != '/') {
            name = "/" + (String)name;
        }
        return new URL("jar:" + this.archiveURI.toASCIIString() + "!" + (String)name);
    }

    public synchronized boolean exists(String name) throws IOException {
        if (this.cachedEntryNames != null) {
            return this.cachedEntryNames.contains(name);
        }
        return this.getEntry(name) != null;
    }

    public long getEntrySize(String name) {
        try {
            URLConnection cnx = this.entryURL(name).openConnection();
            return cnx.getContentLength();
        }
        catch (Exception ex) {
            Logger.getLogger(HTTPInputArchive.class.getName()).log(Level.SEVERE, null, ex);
            return -1L;
        }
    }

    public void open(URI uri) throws IOException {
        this.archiveURI = uri;
        this.archiveURL = uri.toURL();
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        throw new UnsupportedOperationException("Nested archives not supported in ACC");
    }

    public boolean exists() {
        if (this.exists != null) {
            return this.exists;
        }
        this.exists = Boolean.FALSE;
        try (InputStream is = this.archiveURL.openStream();){
            this.exists = Boolean.TRUE;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.exists;
    }

    public boolean delete() {
        throw new UnsupportedOperationException("delete not supported");
    }

    public boolean renameTo(String name) {
        throw new UnsupportedOperationException("renameTo supported");
    }

    public void close() throws IOException {
    }

    public Enumeration<String> entries() {
        try {
            final Iterator<String> it = this.entryNames().iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)it.next();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized Collection<String> entryNames() throws IOException {
        if (this.cachedEntryNames == null) {
            this.cachedEntryNames = new ArrayList<String>();
            try (JarInputStream jis = new JarInputStream(this.archiveURL.openStream());){
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    this.cachedEntryNames.add(entry.getName());
                }
            }
        }
        return this.cachedEntryNames;
    }

    public Enumeration<String> entries(final String prefix) {
        try {
            final Iterator<String> it = this.entryNames().iterator();
            return new Enumeration<String>(){
                private String nextName = this.nextMatch();

                @Override
                public boolean hasMoreElements() {
                    return this.nextName != null;
                }

                @Override
                public String nextElement() {
                    String result = this.nextName;
                    this.nextName = this.nextMatch();
                    return result;
                }

                private String nextMatch() {
                    String nextMatch = null;
                    while (it.hasNext() && !(nextMatch = (String)it.next()).startsWith(prefix)) {
                    }
                    return nextMatch;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> getDirectories() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDirectory(String name) {
        ZipInputStream jis = null;
        try {
            jis = new JarInputStream(this.entryURL(name).openStream());
            JarEntry entry = ((JarInputStream)jis).getNextJarEntry();
            boolean bl = entry.isDirectory();
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized Manifest getManifest() throws IOException {
        if (this.cachedManifest != null) {
            return this.cachedManifest;
        }
        InputStream manifestIS = this.getEntry("META-INF/MANIFEST.MF");
        if (manifestIS == null) {
            return null;
        }
        this.cachedManifest = new Manifest(manifestIS);
        return this.cachedManifest;
    }

    public URI getURI() {
        return this.archiveURI;
    }

    public long getArchiveSize() throws SecurityException {
        if (this.cachedArchiveSize != -2) {
            return this.cachedArchiveSize;
        }
        try {
            URLConnection cnx = this.archiveURL.openConnection();
            this.cachedArchiveSize = cnx.getContentLength();
            return this.cachedArchiveSize;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.archiveURI.getPath();
    }
}

