/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.common.XMLActionReporter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.kernel.KernelLoggerInfo;

public class DynamicReloader
implements Runnable {
    private static final String RELOAD_FILE_NAME = ".reload";
    private final SyncBoolean inProgress;
    private Map<String, AppReloadInfo> appReloadInfo;
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private final Applications applications;
    private final Logger logger = KernelLoggerInfo.getLogger();
    private final ServiceLocator locator;
    private final Subject kernelSubject;

    DynamicReloader(Applications applications, ServiceLocator locator) throws URISyntaxException {
        this.applications = applications;
        this.locator = locator;
        this.initAppReloadInfo(applications);
        this.inProgress = new SyncBoolean(false);
        InternalSystemAdministrator kernelIdentity = (InternalSystemAdministrator)locator.getService(InternalSystemAdministrator.class, new Annotation[0]);
        this.kernelSubject = kernelIdentity.getSubject();
    }

    private synchronized void initAppReloadInfo(Applications applications) throws URISyntaxException {
        this.appReloadInfo = new HashMap<String, AppReloadInfo>();
        this.logger.fine("[Reloader] Preparing list of apps to monitor:");
        for (ApplicationName m : applications.getModules()) {
            Application app;
            if (!(m instanceof Application) || Boolean.parseBoolean((app = (Application)m).getDeployProperties().getProperty("isLifecycle"))) continue;
            AppReloadInfo info = new AppReloadInfo(app);
            this.appReloadInfo.put(app.getName(), info);
            this.logger.fine("[Reloader] Monitoring " + app.getName() + " at " + app.getLocation());
        }
    }

    @Override
    public void run() {
        this.markInProgress();
        try {
            this.reloadApps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clearInProgress();
        }
    }

    void cancel() {
        this.cancelRequested.set(true);
    }

    void init() {
        this.cancelRequested.set(false);
    }

    private void reloadApps() throws URISyntaxException, IOException {
        List<AppReloadInfo> appsToReload = this.chooseAppsToReload();
        for (AppReloadInfo appInfo : appsToReload) {
            if (this.cancelRequested.get()) break;
            this.reloadApp(appInfo);
        }
    }

    private synchronized List<AppReloadInfo> chooseAppsToReload() throws URISyntaxException {
        ArrayList<AppReloadInfo> result = new ArrayList<AppReloadInfo>();
        HashSet<AppReloadInfo> possiblyUndeployedApps = new HashSet<AppReloadInfo>(this.appReloadInfo.values());
        for (ApplicationName m : this.applications.getModules()) {
            Application app;
            if (!(m instanceof Application) || Boolean.parseBoolean((app = (Application)m).getDeployProperties().getProperty("isLifecycle"))) continue;
            AppReloadInfo reloadInfo = this.findOrCreateAppReloadInfo(app);
            if (reloadInfo.needsReload()) {
                this.logger.fine("[Reloader] Selecting app " + reloadInfo.getApplication().getName() + " to reload");
                result.add(reloadInfo);
            }
            possiblyUndeployedApps.remove(reloadInfo);
        }
        for (AppReloadInfo info : possiblyUndeployedApps) {
            this.logger.fine("[Reloader] Removing undeployed app " + info.getApplication().getName() + " from reload info");
            this.appReloadInfo.remove(info.getApplication().getName());
        }
        return result;
    }

    private synchronized AppReloadInfo findOrCreateAppReloadInfo(Application app) throws URISyntaxException {
        AppReloadInfo result = this.appReloadInfo.get(app.getName());
        if (result == null) {
            this.logger.fine("[Reloader] Recording info for new app " + app.getName() + " at " + app.getLocation());
            result = new AppReloadInfo(app);
            this.appReloadInfo.put(app.getName(), result);
        }
        return result;
    }

    private void reloadApp(AppReloadInfo appInfo) throws IOException {
        this.logger.fine("[Reloader] Reloading " + appInfo.getApplication().getName());
        CommandRunnerImpl commandRunner = (CommandRunnerImpl)this.locator.getService(CommandRunnerImpl.class, new Annotation[0]);
        ParameterMap deployParam = new ParameterMap();
        deployParam.set((Object)"force", (Object)Boolean.TRUE.toString());
        deployParam.set((Object)"path", (Object)appInfo.getApplicationDirectory().getCanonicalPath());
        deployParam.set((Object)"name", (Object)appInfo.getApplication().getName());
        deployParam.set((Object)"keepreposdir", (Object)"true");
        CommandInvocation invocation = commandRunner.getCommandInvocation("deploy", new XMLActionReporter(), this.kernelSubject).parameters(deployParam);
        invocation.execute();
        appInfo.recordLoad();
    }

    private void markInProgress() {
        this.inProgress.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInProgress() {
        SyncBoolean syncBoolean = this.inProgress;
        synchronized (syncBoolean) {
            this.inProgress.set(false);
            this.inProgress.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() throws InterruptedException {
        SyncBoolean syncBoolean = this.inProgress;
        synchronized (syncBoolean) {
            while (this.inProgress.get()) {
                this.inProgress.wait();
            }
        }
    }

    private static class SyncBoolean {
        private boolean b;

        private SyncBoolean(boolean initialValue) {
            this.b = initialValue;
        }

        private synchronized void set(boolean value) {
            this.b = value;
        }

        private synchronized boolean get() {
            return this.b;
        }
    }

    private static final class AppReloadInfo {
        private final File reloadFile;
        private long latestRecordedLoad;
        private final Application app;
        private final File appDir;

        private AppReloadInfo(Application app) throws URISyntaxException {
            this.app = app;
            this.appDir = app.getLocation() == null ? null : new File(new URI(app.getLocation()));
            this.reloadFile = new File(this.appDir, DynamicReloader.RELOAD_FILE_NAME);
            this.recordLoad();
        }

        private Application getApplication() {
            return this.app;
        }

        private boolean needsReload() {
            boolean answer = this.reloadFile.lastModified() > this.latestRecordedLoad;
            return answer;
        }

        private void recordLoad() {
            this.latestRecordedLoad = System.currentTimeMillis();
        }

        private File getApplicationDirectory() {
            return this.appDir;
        }
    }
}

