/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.Serializable;

public class SizeString
implements Serializable {
    private static final long serialVersionUID = -5880956432159677874L;
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long B = 1L;
    String str = null;
    long bytes = 0L;

    public SizeString(String str) {
        this.setString(str);
    }

    public SizeString() {
        this.setString("0b");
    }

    public SizeString(long newKbytes) {
        this.setKBytes(newKbytes);
    }

    public void setString(String setstr) {
        this.str = setstr;
        long multiplier = 1L;
        if (this.str == null) {
            this.str = null;
            this.bytes = 0L;
            return;
        }
        if (Character.isLetter(setstr.charAt(this.str.length() - 1))) {
            char multchar = setstr.charAt(this.str.length() - 1);
            setstr = this.str.substring(0, this.str.length() - 1);
            switch (multchar) {
                case 'M': 
                case 'm': {
                    multiplier = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    multiplier = 1024L;
                    break;
                }
                case 'B': 
                case 'b': {
                    multiplier = 1L;
                    break;
                }
                default: {
                    throw new NumberFormatException("Unknown size " + multchar);
                }
            }
        }
        int val = Integer.parseInt(setstr);
        this.bytes = (long)val * multiplier;
    }

    public String getString() {
        return this.str;
    }

    public String getByteString() {
        return this.bytes + "b";
    }

    public String getKByteString() {
        return this.getKBytes() + "K";
    }

    public String getMByteString() {
        return this.getMBytes() + "M";
    }

    public void setKBytes(long newKbytes) {
        this.str = newKbytes + "K";
        this.bytes = newKbytes * 1024L;
    }

    public void setMBytes(long newMbytes) {
        this.str = newMbytes + "M";
        this.bytes = newMbytes * 0x100000L;
    }

    public void setBytes(long newbytes) {
        this.str = newbytes + "b";
        this.bytes = newbytes * 1L;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getKBytes() {
        return this.bytes == 0L ? 0L : this.bytes / 1024L;
    }

    public long getMBytes() {
        return this.bytes == 0L ? 0L : this.bytes / 0x100000L;
    }

    public String toString() {
        return this.getString();
    }
}

