/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import java.util.ArrayList;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="bean-method-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Ejb Method Statistics")
public class EjbMethodStatsProvider {
    private CountStatisticImpl executionStat = new CountStatisticImpl("ExecutionTime", "Milliseconds", "Provides the time in milliseconds spent during the last successful/unsuccessful attempt to execute the operation.");
    private CountStatisticImpl invocationStat = new CountStatisticImpl("TotalNumInvocations", "count", "Provides the total number of invocations of the method.");
    private CountStatisticImpl errorStat = new CountStatisticImpl("TotalNumErrors", "count", "Provides the total number of errors that occured during invocation or execution of an operation.");
    private CountStatisticImpl successStat = new CountStatisticImpl("TotalNumSuccess", "count", "Provides the total number of successful invocations of the method.");
    private TimeStatisticImpl methodStat = null;
    private static ThreadLocal execThreadLocal = new ThreadLocal();
    private String mname = null;
    private boolean registered = false;

    EjbMethodStatsProvider(String mname) {
        this.mname = mname;
        long now = System.currentTimeMillis();
        this.methodStat = new TimeStatisticImpl(0L, 0L, 0L, 0L, "MethodStatistic", "", "Provides the number of times an operation was called, the total time that was spent during the invocation and so on", now, now);
    }

    @ManagedAttribute(id="methodstatistic")
    @Description(value="Number of times the operation is called; total time spent during invocation, and so on.")
    public TimeStatistic getMethodStatistic() {
        return this.methodStat;
    }

    @ManagedAttribute(id="totalnumerrors")
    @Description(value="Number of times the method execution resulted in an exception")
    public CountStatistic getTotalNumErrors() {
        return this.errorStat;
    }

    @ManagedAttribute(id="totalnumsuccess")
    @Description(value="Number of times the method successfully executed")
    public CountStatistic getTotalNumSuccess() {
        return this.successStat;
    }

    @ManagedAttribute(id="executiontime")
    @Description(value="Time (ms) spent executing method for the last successful/unsuccessful attempt to execute the operation")
    public CountStatistic getTotalExecutionTime() {
        return this.executionStat;
    }

    public String getStringifiedMethodName() {
        return this.mname;
    }

    void registered() {
        this.registered = true;
    }

    void unregistered() {
        this.registered = false;
    }

    boolean isRegistered() {
        return this.registered;
    }

    void methodStart() {
        ArrayList<Long> list = (ArrayList<Long>)execThreadLocal.get();
        if (list == null) {
            list = new ArrayList<Long>(5);
            execThreadLocal.set(list);
        }
        list.add(System.currentTimeMillis());
        this.invocationStat.increment();
    }

    void methodEnd(boolean success) {
        ArrayList list = (ArrayList)execThreadLocal.get();
        if (list != null && list.size() > 0) {
            int index = list.size();
            Long startTime = (Long)list.remove(index - 1);
            if (success) {
                this.successStat.increment();
            } else {
                this.errorStat.increment();
            }
            if (startTime != null) {
                long diff = System.currentTimeMillis() - startTime;
                this.executionStat.setCount(diff);
                this.methodStat.incrementCount(diff);
            }
        }
    }
}

