/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ModifyQuery;

public class DataModifyQuery
extends ModifyQuery {
    protected boolean hasModifyRow;

    public DataModifyQuery() {
    }

    public DataModifyQuery(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    public DataModifyQuery(Call call) {
        this();
        this.setCall(call);
    }

    public boolean hasModifyRow() {
        return this.hasModifyRow;
    }

    public void setHasModifyRow(boolean hasModifyRow) {
        this.hasModifyRow = hasModifyRow;
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.session.isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
            if (!unitOfWork.getCommitManager().isActive() && !unitOfWork.isInTransaction()) {
                unitOfWork.beginEarlyTransaction();
            }
            unitOfWork.setWasNonObjectLevelModifyQueryExecuted(true);
        }
        return this.getQueryMechanism().executeNoSelect();
    }

    @Override
    public boolean isDataModifyQuery() {
        return true;
    }

    @Override
    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareExecuteNoSelect();
    }

    @Override
    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (!this.hasModifyRow) {
            this.modifyRow = this.translationRow;
        }
    }
}

