/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractNodeBuilderImpl;
import io.helidon.config.ListNodeImpl;
import io.helidon.config.MergeableNode;
import io.helidon.config.ObjectNodeBuilderImpl;
import io.helidon.config.ObjectNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.Objects;
import java.util.Optional;

public class ValueNodeImpl
implements ConfigNode.ValueNode,
MergeableNode {
    private final String value;
    private String description;

    protected ValueNodeImpl(String value) {
        this.value = value;
        this.description = null;
    }

    public Optional<String> value() {
        return Optional.of(this.value);
    }

    public String get() {
        return this.value;
    }

    public static ValueNodeImpl create(String value) {
        return new ValueNodeImpl(value);
    }

    static ValueNodeImpl wrap(ConfigNode.ValueNode valueNode) {
        if (valueNode instanceof ValueNodeImpl) {
            return (ValueNodeImpl)valueNode;
        }
        return ValueNodeImpl.create(valueNode.get());
    }

    @Override
    public MergeableNode merge(MergeableNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                return this.mergeWithObjectNode((ObjectNodeImpl)node);
            }
            case LIST: {
                return this.mergeWithListNode((ListNodeImpl)node);
            }
            case VALUE: {
                return node;
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    private MergeableNode mergeWithListNode(ListNodeImpl node) {
        if (node.hasValue()) {
            return node;
        }
        return node.merge(this);
    }

    private MergeableNode mergeWithObjectNode(ObjectNodeImpl node) {
        ObjectNodeBuilderImpl builder = ObjectNodeBuilderImpl.create();
        node.forEach((name, member) -> builder.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(name), AbstractNodeBuilderImpl.wrap(member)));
        node.value().or(this::value).ifPresent(builder::value);
        return builder.build();
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueNodeImpl valueNode = (ValueNodeImpl)o;
        return Objects.equals(this.value, valueNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public ValueNodeImpl initDescription(String description) {
        this.description = description;
        return this;
    }

    public String description() {
        return this.description;
    }

    @Override
    public boolean hasValue() {
        return true;
    }
}

