/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class ResourceEnvRefNode
extends DeploymentDescriptorNode<ResourceEnvReferenceDescriptor> {
    private ResourceEnvReferenceDescriptor descriptor;

    public static void writeResoureEnvReferences(Node parent, ResourceEnvReferenceContainer descriptor) {
        Iterator<ResourceEnvReferenceDescriptor> resRefs = descriptor.getResourceEnvReferenceDescriptors().iterator();
        if (resRefs.hasNext()) {
            ResourceEnvRefNode resourceEnvRefNode = new ResourceEnvRefNode();
            while (resRefs.hasNext()) {
                resourceEnvRefNode.write(parent, "resource-env-ref", resRefs.next());
            }
        }
    }

    @Override
    public ResourceEnvReferenceDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ResourceEnvReferenceDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("resource-env-ref-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof ResourceEnvReferenceContainer) {
                try {
                    this.descriptor = ((ResourceEnvReferenceContainer)parentDesc).getResourceEnvReferenceByName(value);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    private Node write(Node parent, String nodeName, ResourceEnvReferenceDescriptor ejbRef) {
        Node resRefNode = super.writeDescriptor(parent, nodeName, ejbRef);
        ResourceEnvRefNode.appendTextChild(resRefNode, "resource-env-ref-name", ejbRef.getName());
        ResourceEnvRefNode.appendTextChild(resRefNode, "jndi-name", ejbRef.getJndiName());
        return resRefNode;
    }
}

