/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import org.glassfish.tyrus.spi.Writer;

public class GrizzlyWriter
extends Writer {
    private final TaskProcessor taskProcessor;
    final Connection connection;

    public GrizzlyWriter(Connection connection) {
        this.connection = connection;
        this.connection.configureBlocking(false);
        this.taskProcessor = new TaskProcessor(new WriterCondition());
    }

    public void write(final ByteBuffer buffer, final org.glassfish.tyrus.spi.CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.connection.isOpen()) {
            completionHandler.failed((Throwable)new IllegalStateException("Connection is not open."));
            return;
        }
        Buffer message = Buffers.wrap((MemoryManager)this.connection.getTransport().getMemoryManager(), (ByteBuffer)buffer);
        EmptyCompletionHandler emptyCompletionHandler = new EmptyCompletionHandler(){

            public void cancelled() {
                if (completionHandler != null) {
                    completionHandler.cancelled();
                }
            }

            public void completed(Object result) {
                if (completionHandler != null) {
                    completionHandler.completed((Object)buffer);
                }
            }

            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
            }
        };
        this.taskProcessor.processTask(new WriteTask(this.connection, message, emptyCompletionHandler));
    }

    public void close() {
        this.taskProcessor.processTask(new CloseTask(this.connection));
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GrizzlyWriter && this.connection.equals(((GrizzlyWriter)((Object)obj)).connection);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " " + this.connection.toString() + " " + this.connection.hashCode();
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final Connection connection;

        private CloseTask(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void execute() {
            this.connection.closeSilently();
        }
    }

    private class WriteTask
    extends TaskProcessor.Task {
        private final Connection connection;
        private final Buffer message;
        private final EmptyCompletionHandler completionHandler;

        private WriteTask(Connection connection, Buffer message, EmptyCompletionHandler completionHandler) {
            this.connection = connection;
            this.message = message;
            this.completionHandler = completionHandler;
        }

        @Override
        public void execute() {
            this.connection.write((Object)this.message, (CompletionHandler)this.completionHandler);
        }
    }

    private class WriterCondition
    implements TaskProcessor.Condition {
        private final AtomicBoolean writeHandlerRegistered = new AtomicBoolean(false);

        private WriterCondition() {
        }

        @Override
        public boolean isValid() {
            if (!GrizzlyWriter.this.connection.canWrite() && this.writeHandlerRegistered.compareAndSet(false, true)) {
                GrizzlyWriter.this.connection.notifyCanWrite(new WriteHandler(){

                    public void onWritePossible() throws Exception {
                        WriterCondition.this.writeHandlerRegistered.set(false);
                        GrizzlyWriter.this.taskProcessor.processTask();
                    }

                    public void onError(Throwable t) {
                        WriterCondition.this.writeHandlerRegistered.set(false);
                        Logger.getLogger(GrizzlyWriter.class.getName()).log(Level.WARNING, t.getMessage(), t);
                    }
                });
                return false;
            }
            return true;
        }
    }
}

