/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.util.Map;

public final class ValueExpressionSortCriteria
extends SortCriteria {
    private static final long serialVersionUID = -1400195724479592404L;
    private String valueExpression;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private final String rowProviderLock = "rowProviderLock";

    public ValueExpressionSortCriteria() {
    }

    public ValueExpressionSortCriteria(String newValueExpression) {
        this.valueExpression = newValueExpression;
    }

    public ValueExpressionSortCriteria(String newValueExpression, boolean newAscending) {
        this.valueExpression = newValueExpression;
        this.setAscending(newAscending);
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String newValueExpression) {
        this.valueExpression = newValueExpression;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String newRequestMapKey) {
        this.requestMapKey = newRequestMapKey;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if ((name == null || "".equals(name)) && this.valueExpression != null && !"".equals(this.valueExpression)) {
            return this.valueExpression;
        }
        return name;
    }

    public String getCriteriaKey() {
        if (this.valueExpression != null) {
            return this.valueExpression;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSortValue(TableDataProvider provider, RowKey row) {
        if (this.valueExpression == null || "".equals(this.valueExpression)) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueExpression valueBinding = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), this.valueExpression, Object.class);
        if (valueBinding == null) {
            return null;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String string = "rowProviderLock";
        synchronized ("rowProviderLock") {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            Object value = valueBinding.getValue(facesContext.getELContext());
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return value;
        }
    }
}

