/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.CommonTasksSection;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.json.JsonObject;
import java.io.IOException;

public class CommonTasksGroupRenderer
extends AbstractRenderer {
    private static final String TITLE_SPAN = "_groupTitle";
    public static final String GROUP_TITLE = "commonTasks.groupTitle";
    public static final String SKIP_GROUP = "commonTasks.skipTagAltText";
    private static final String SKIP_TASKSGROUP = "skipGroup";

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        CommonTasksGroup ctg = (CommonTasksGroup)component;
        if (!ctg.isRendered()) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String title = ctg.getTitle();
        if (title == null) {
            title = theme.getMessage(GROUP_TITLE);
            ctg.setTitle(title);
        }
        writer.startElement("div", (UIComponent)ctg);
        writer.writeAttribute("id", (Object)ctg.getClientId(context), "id");
        String styles = RenderingUtilities.getStyleClasses(context, (UIComponent)ctg, theme.getStyleClass("CTS_GROUP"));
        if (styles != null) {
            writer.writeAttribute("class", (Object)styles, "class");
        }
        if (ctg.getStyle() != null) {
            writer.writeAttribute("style", (Object)ctg.getStyle(), "style");
        }
        StringBuilder jsBuffer = new StringBuilder();
        this.renderTaskGroupHeader(title, writer, context, (UIComponent)ctg, theme);
        if (!(ctg.getParent() instanceof CommonTasksSection)) {
            this.renderJavascriptImages(theme, writer, (UIComponent)ctg, context);
        }
        for (UIComponent comp : ctg.getChildren()) {
            RenderingUtilities.renderComponent(comp, context);
        }
        writer.endElement("div");
    }

    protected void renderJavascriptImages(Theme theme, ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        JsonObject initProps = this.getJSONProperties(context, theme, component);
        JavaScriptUtilities.renderInitScriptTag(writer, "commonTasksSection", initProps);
    }

    protected JsonObject getJSONProperties(FacesContext context, Theme theme, UIComponent component) throws IOException {
        return JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", component.getClientId(context)).add("pic1URL", theme.getImagePath("CTS_RIGHT_TOGGLE_SELECTED")).add("pic2URL", theme.getImagePath("CTS_RIGHT_TOGGLE_OVER")).add("pic3URL", theme.getImagePath("CTS_RIGHT_TOGGLE")).build();
    }

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderTaskGroupHeader(String header, ResponseWriter writer, FacesContext context, UIComponent component, Theme theme) throws IOException {
        StaticText staticText = new StaticText();
        staticText.setParent(component);
        staticText.setId(TITLE_SPAN);
        staticText.setStyleClass(theme.getStyleClass("CTS_HEADER"));
        staticText.setText(header);
        RenderingUtilities.renderComponent((UIComponent)staticText, context);
    }

    public boolean getRendersChildren() {
        return true;
    }
}

