/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.commandrecorder.admingui;

import com.sun.enterprise.v3.admin.AdminCommandJob;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.extras.commandlogger.AdminCommandLogger;

@Named
@RequestScoped
public class CommandRecorder {
    @Inject
    Instance<CommandRunner<AdminCommandJob>> commandRunnerProvider;
    @Inject
    Instance<ActionReport> actionReportProvider;
    @Inject
    Instance<Subject> subjectProvider;

    public boolean isEnabled() {
        return !AdminCommandLogger.LogMode.NO_COMMAND.equals((Object)AdminCommandLogger.LogMode.get());
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setSystemProperty(AdminCommandLogger.LogMode.WRITE_COMMANDS);
        } else {
            this.setSystemProperty(AdminCommandLogger.LogMode.NO_COMMAND);
        }
    }

    private void setSystemProperty(AdminCommandLogger.LogMode propertyValue) {
        CommandInvocation commandInvocation = ((CommandRunner)this.commandRunnerProvider.get()).getCommandInvocation("create-system-properties", (ActionReport)this.actionReportProvider.get(), (Subject)this.subjectProvider.get());
        commandInvocation.parameters(this.parameters(propertyValue)).execute();
    }

    public void toggle() {
        this.setEnabled(!this.isEnabled());
    }

    public String getToggleButtonTitle() {
        return (this.isEnabled() ? "Disable" : "Enable") + " logging commands";
    }

    private ParameterMap parameters(AdminCommandLogger.LogMode propertyValue) {
        ParameterMap data = new ParameterMap();
        data.add((Object)"target", (Object)"server");
        data.add((Object)"DEFAULT", (Object)("glassfish.commandlogger.logmode=" + propertyValue.name()));
        return data;
    }
}

