/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.relationship.unimanyxmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.relationship.unimanyxmany.UniMXMPerson;
import com.sun.ts.tests.jpa.core.relationship.unimanyxmany.UniMXMProject;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uniMXMTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin uniMXMTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            UniMXMProject project1 = new UniMXMProject(1L, "JavaEE", Float.valueOf(500.0f));
            UniMXMProject project2 = new UniMXMProject(2L, "Identity", Float.valueOf(300.0f));
            UniMXMPerson person1 = new UniMXMPerson(Long.valueOf(1L), "Duke");
            UniMXMPerson person2 = new UniMXMPerson(Long.valueOf(2L), "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            Vector<UniMXMProject> projects = new Vector<UniMXMProject>();
            projects.add(project1);
            projects.add(project2);
            person1.setProjects(projects);
            Vector<UniMXMProject> projects2 = new Vector<UniMXMProject>();
            projects2.add(project2);
            person2.setProjects(projects2);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            TestUtil.logTrace((String)"persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            UniMXMPerson newPerson = (UniMXMPerson)this.getEntityManager().find(UniMXMPerson.class, (Object)1L);
            if (newPerson != null) {
                Collection newProjects = newPerson.getProjects();
                for (UniMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    pass2 = true;
                }
            }
            boolean pass3 = false;
            UniMXMPerson newPerson2 = (UniMXMPerson)this.getEntityManager().find(UniMXMPerson.class, (Object)2L);
            if (newPerson2 != null) {
                Collection newProjects2 = newPerson2.getProjects();
                for (UniMXMProject prj : newProjects2) {
                    if (!prj.getName().equals("Identity")) continue;
                    pass3 = true;
                }
            }
            if (pass1 && pass2 && pass3) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("uniMXMTest1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPERSON_UNIMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

