/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.untyped;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.SimpleMappingTester;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class UntypedMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        UntypedMappingTest t = new UntypedMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void testObjectMapping() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create();
        String jsonString = jsonb.toJson(new Object(){
            private String stringProperty = "Test String";
            private Number numericProperty = 0;
            private boolean booleanProperty = false;
            private Object nullProperty = null;

            public String getStringProperty() {
                return this.stringProperty;
            }

            public Number getNumericProperty() {
                return this.numericProperty;
            }

            public boolean getBooleanProperty() {
                return this.booleanProperty;
            }

            public Object getNullProperty() {
                return this.nullProperty;
            }
        });
        if (!jsonString.matches("\\{\\s*\"booleanProperty\"\\s*:\\s*false\\s*\\,\\s*\"numericProperty\"\\s*:\\s*0[\\.0]?+\\s*,\\s*\"stringProperty\"\\s*:\\s*\"Test String\"\\s*}")) {
            throw new EETest.Fault("Failed to correctly marshal object with String, Number, Boolean and null fields.");
        }
        Object unmarshalledObject = jsonb.fromJson("{ \"numericProperty\" : 0.0, \"booleanProperty\" : false, \"stringProperty\" : \"Test String\" }", Object.class);
        if (!Map.class.isInstance(unmarshalledObject) || !new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = 10L;
            {
                this.put("numericProperty", BigDecimal.valueOf(0.0));
                this.put("booleanProperty", false);
                this.put("stringProperty", "Test String");
            }
        }.equals(unmarshalledObject)) {
            throw new EETest.Fault("Failed to correctly unmarshal object with string, number, boolean and null JSON values into a predictable order Map<String,Object> with java.lang.String, java.math.BigDecimal, java.lang.Boolean and null values.");
        }
    }

    public Status testArrayMapping() throws EETest.Fault {
        return new SimpleMappingTester<List>(List.class).test(Arrays.asList("Test String"), "\\[\\s*\"Test String\"s*\\]", "[ \"Test String\" ]", Arrays.asList("Test String"));
    }
}

