/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class MultiSelectPanel
extends JPanel {
    private TestTreeModel ttm;
    private TreePanelModel tpm;
    private JList nodeList;
    private DefaultListModel listModel;
    private Object[] nodes;
    private UIFactory uif;
    private volatile boolean needToUpdateGUIWhenShown;
    private static boolean debug = Debug.getBoolean(MultiSelectPanel.class);

    MultiSelectPanel(UIFactory uif, TreePanelModel model, TestTreeModel ttm) {
        this.uif = uif;
        this.tpm = model;
        this.ttm = ttm;
        this.initGUI();
    }

    void setNodes(Object[] nodes) {
        this.nodes = nodes;
        this.updatePanel(nodes);
    }

    protected void initGUI() {
        this.setName("multiselect");
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(150, 100));
        this.listModel = new DefaultListModel();
        this.nodeList = this.uif.createList("ms.nlist", this.listModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.add((Component)this.uif.createMessageArea("ms.help"), gbc);
        gbc.weighty = 9.0;
        gbc.gridy = 1;
        gbc.fill = 1;
        this.nodeList.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("ms.nlist")));
        this.nodeList.setCellRenderer(RenderingUtilities.createTRTNodeRenderer());
        this.add((Component)new JScrollPane(this.nodeList), gbc);
        ComponentListener cl = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (MultiSelectPanel.this.needToUpdateGUIWhenShown) {
                    MultiSelectPanel.this.updateGUI();
                    MultiSelectPanel.this.needToUpdateGUIWhenShown = false;
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        };
        this.addComponentListener(cl);
        ContextHelpManager.setHelpIDString(this, "browse.multiselectionTab.csh");
    }

    protected void updatePanel(Object[] nodes) {
        if (this.isVisible()) {
            this.updateGUI();
        } else {
            this.needToUpdateGUIWhenShown = true;
        }
    }

    Object[] getNodes() {
        return this.nodes;
    }

    protected void updateGUI() {
        this.listModel.removeAllElements();
        if (this.nodes == null) {
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            this.listModel.addElement(this.nodes[i]);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

