/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.lrapitest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private TestBean bRef = null;
    private TestBeanHome bHome = null;
    private TSNamingContext nctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.bHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void test1() throws EETest.Fault {
        this.logTrace("test1");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Perform Local/Remote object access");
            pass = this.bRef.test1();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        this.logTrace("test2");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Attempt Remote/Local access to Session Bean when only Remote");
            pass = this.bRef.test2();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        this.logTrace("test3");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Attempt Remote/Local access to Session Bean when only Local");
            pass = this.bRef.test3();
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        this.logTrace("test4");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("EJBLocalHome tests ...");
            pass = this.bRef.test4();
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        this.logTrace("test5");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("EJBLocalObject tests ...");
            pass = this.bRef.test5();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test6() throws EETest.Fault {
        this.logTrace("test6");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Perform Local/Remote object passing references");
            pass = this.bRef.test6();
        }
        catch (Exception e) {
            throw new EETest.Fault("test6 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
    }

    public void test7() throws EETest.Fault {
        this.logTrace("test7");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Test for jakarta.ejb.NoSuchObjectLocalException");
            pass = this.bRef.test7();
        }
        catch (Exception e) {
            throw new EETest.Fault("test7 failed", e);
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test7 failed");
        }
    }

    public void test8() throws EETest.Fault {
        this.logTrace("test8");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Test for jakarta.ejb.RemoveException on Local Interface");
            pass = this.bRef.test8();
        }
        catch (Exception e) {
            throw new EETest.Fault("test8 failed", e);
        }
        finally {
            try {
                this.bRef.cleanUpStatefulBean();
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test8 failed");
        }
    }

    public void test9() throws EETest.Fault {
        this.logTrace("test9");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Test for jakarta.ejb.RemoveException on Remote Interface");
            pass = this.bRef.test9();
        }
        catch (Exception e) {
            throw new EETest.Fault("test9 failed", e);
        }
        finally {
            try {
                this.bRef.cleanUpStatefulBean();
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test9 failed");
        }
    }

    public void test10() throws EETest.Fault {
        this.logTrace("test10");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Test for jakarta.ejb.RemoveException on Local Home Interface");
            pass = this.bRef.test10();
        }
        catch (Exception e) {
            throw new EETest.Fault("test10 failed", e);
        }
        finally {
            try {
                this.bRef.cleanUpStatefulBean();
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test10 failed");
        }
    }

    public void test11() throws EETest.Fault {
        this.logTrace("test11");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Test for jakarta.ejb.RemoveException on Remote Home Interface");
            pass = this.bRef.test11();
        }
        catch (Exception e) {
            throw new EETest.Fault("test11 failed", e);
        }
        finally {
            try {
                this.bRef.cleanUpStatefulBean();
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test11 failed");
        }
    }

    public void test12() throws EETest.Fault {
        this.logTrace("test12");
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.bRef = this.bHome.create(this.props);
            this.logMsg("Test the RemoveException allows client to recover");
            pass = this.bRef.test12();
        }
        catch (Exception e) {
            throw new EETest.Fault("test12 failed", e);
        }
        finally {
            try {
                this.bRef.cleanUpStatefulBean();
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test12 failed");
        }
    }
}

