/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.query.language;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Country;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Department;
import com.sun.ts.tests.jpa.common.schema30.HardwareProduct;
import com.sun.ts.tests.jpa.common.schema30.LineItem;
import com.sun.ts.tests.jpa.common.schema30.Order;
import com.sun.ts.tests.jpa.common.schema30.Product;
import com.sun.ts.tests.jpa.common.schema30.SoftwareProduct;
import com.sun.ts.tests.jpa.common.schema30.Util;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Orders for Customer: Robert E. Bissett");
            List o = this.getEntityManager().createQuery("Select Distinct o from Order AS o WHERE o.customer.name = :name").setParameter("name", (Object)"Robert E. Bissett").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute findAllCustomers");
            List result = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer AS c").getResultList();
            String[] expectedPKs = new String[this.customerRef.length];
            for (int i = 0; i < this.customerRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + this.customerRef.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest2 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers with Alias: imc");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FrOm Customer c, In(c.aliases) a WHERE a.alias = :aName").setParameter("aName", (Object)"imc").getResultList();
            String[] expectedPKs = new String[]{"8"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest3 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"3");
            TestUtil.logTrace((String)"find Customer with Home Address in Swansea");
            Query q = this.getEntityManager().createQuery("SELECT c from Customer c WHERE c.home.street = :street AND c.home.city = :city AND c.home.state = :state and c.home.zip = :zip").setParameter("street", (Object)"125 Moxy Lane").setParameter("city", (Object)"Swansea").setParameter("state", (Object)"MA").setParameter("zip", (Object)"11345");
            Customer c = (Customer)q.getSingleResult();
            if (expected == c) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest4 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all Customers with AXP Credit Cards");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) fRoM Customer c, IN(c.creditCards) a where a.type = :ccard").setParameter("ccard", (Object)"AXP").getResultList();
            String[] expectedPKs = new String[]{"1", "4", "5", "8", "9", "12", "15"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest5 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Customers with Home Address Information");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c from Customer c WHERE c.home.street = :street OR c.home.city = :city OR c.home.state = :state or c.home.zip = :zip").setParameter("street", (Object)"47 Skyline Drive").setParameter("city", (Object)"Chelmsford").setParameter("state", (Object)"VT").setParameter("zip", (Object)"02155").getResultList();
            String[] expectedPKs = new String[]{"1", "10", "11", "13"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest6 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Products");
            List p = this.getEntityManager().createQuery("Select DISTINCT Object(P) From Product p where P.quantity < 10").getResultList();
            String[] expectedPKs = new String[]{"15", "21"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest7 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where the total price is NOT less than $4500");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o WHERE NOT o.totalPrice < 4500").getResultList();
            String[] expectedPKs = new String[]{"5", "11", "16"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest8 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where the customer name is Karen R. Tegan OR the total price is less than $100");
            List o = this.getEntityManager().createQuery("SeLeCt DiStInCt oBjEcT(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' OR o.totalPrice < 100").getResultList();
            String[] expectedPKs = new String[]{"6", "9", "10", "12", "13"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest9 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where line item quantity is 1 AND the order total less than 100 or customer name is Robert E. Bissett");
            List o = this.getEntityManager().createQuery("select distinct Object(o) FROM Order AS o, in(o.lineItemsCollection) l WHERE (l.quantity < 2) AND ((o.totalPrice < (3 + 54 * 2 + -8)) OR (o.customer.name = 'Robert E. Bissett'))").getResultList();
            String[] expectedPKs = new String[]{"4", "9", "12", "13"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest10 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest11() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders with line item quantity < 2 for customer Robert E. Bissett");
            List o = this.getEntityManager().createQuery("SELECT DISTINCT Object(o) FROM Order o, in(o.lineItemsCollection) l WHERE l.quantity < 2 AND o.customer.name = 'Robert E. Bissett'").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest11 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest12() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders with a total price BETWEEN $1000 and $1200");
            List o = this.getEntityManager().createQuery("SELECT DISTINCT Object(o) From Order o where o.totalPrice BETWEEN 1000 AND 1200").getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "14"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest12 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest13() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders with a total price NOT BETWEEN $1000 and $1200");
            List o = this.getEntityManager().createQuery("SELECT DISTINCT Object(o) From Order o where o.totalPrice NOT bETwEeN 1000 AND 1200").getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest13 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest14() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders that do not have approved Credit Cards");
            List o = this.getEntityManager().createQuery("select distinct Object(o) From Order o WHERE o.creditCard.approved = FALSE").getResultList();
            String[] expectedPKs = new String[]{"1", "7", "11", "13", "18", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 6 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest14 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest15() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"5");
            TestUtil.logTrace((String)"find customer with name: Stephen S. D'Milla");
            Query q = this.getEntityManager().createQuery("sElEcT c FROM Customer c Where c.name = :cName").setParameter("cName", (Object)"Stephen S. D'Milla");
            Customer c = (Customer)q.getSingleResult();
            if (expected == c) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest15 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest16() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers IN home city: Lexington");
            List c = this.getEntityManager().createQuery("select distinct c FROM Customer c WHERE c.home.city IN ('Lexington')").getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest16 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest17() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers NOT IN home city: Swansea or Brookline");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) FROM Customer c Left Outer Join c.home h WHERE  h.city Not iN ('Swansea', 'Brookline')").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6", "7", "8", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest17 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest18() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers with home ZIP CODE that ends in 77");
            List c = this.getEntityManager().createQuery("select distinct Object(c) FROM Customer c WHERE c.home.zip LIKE '%77'").getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest18 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest19() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers with a home zip code that does not contain 44 in the third and fourth position");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.home.zip not like '%44_'").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest19 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest20() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who do not have aliases");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.aliases IS EMPTY").getResultList();
            String[] expectedPKs = new String[]{"6", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest20 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest21() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who have aliases");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.aliases IS NOT EMPTY").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest21 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest22() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who have a null work zip code");
            List c = this.getEntityManager().createQuery("sELEct dIsTiNcT oBjEcT(c) FROM Customer c WHERE c.work.zip IS NULL").getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest22 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest23() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who do not have null work zip code entry");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.work.zip IS NOT NULL").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 17 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest23 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest24() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all aliases who have match: stevie");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) From Alias a WHERE a.alias = CONCAT('ste', 'vie')").getResultList();
            String[] expectedPKs = new String[]{"14"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + a.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest24 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest25() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all aliases containing the substring: iris");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) From Alias a WHERE a.alias = SUBSTRING(:string1, :int2, :int3)").setParameter("string1", (Object)"iris").setParameter("int2", (Object)1).setParameter("int3", (Object)4).getResultList();
            String[] expectedPKs = new String[]{"20"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + a.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest25 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest26() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find aliases whose alias name is greater than 4 characters");
            List a = this.getEntityManager().createQuery("Select Distinct OBjeCt(a) From Alias a WHERE LENGTH(a.alias) > 4").getResultList();
            String[] expectedPKs = new String[]{"8", "10", "13", "14", "18", "28", "29"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + a.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest26 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest27() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing ABS with numeric Java object types");
            TestUtil.logTrace((String)"find all Orders with a total price greater than 1180");
            List o = this.getEntityManager().createQuery("Select DISTINCT Object(o) From Order o WHERE :dbl < ABS(o.totalPrice)").setParameter("dbl", (Object)1180.0).getResultList();
            String[] expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 9 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            TestUtil.logMsg((String)"Testing ABS with primitive numeric type");
            TestUtil.logTrace((String)"find all Orders with a total price greater than 1180");
            o = this.getEntityManager().createQuery("Select DISTINCT Object(o) From Order o WHERE o.totalPrice > ABS(:dbl)").setParameter("dbl", (Object)1180.55).getResultList();
            expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 9 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest27 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest28() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all aliases who contain the string: ev in their alias name");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) from Alias a where LOCATE('ev', a.alias) = 3").getResultList();
            String[] expectedPKs = new String[]{"13", "14", "18"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + a.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest28 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest29() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find aliases who are members of customersNoop");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) FROM Alias a WHERE a.customerNoop MEMBER OF a.customersNoop").getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(a, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + a.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest29 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest30() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find aliases who are NOT members of collection");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) FROM Alias a WHERE a.customerNoop NOT MEMBER OF a.customersNoop").getResultList();
            String[] expectedPKs = new String[this.aliasRef.length];
            for (int i = 0; i < this.aliasRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(a, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + this.aliasRef.length + "references, got: " + a.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest30 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest31() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers with an alias LIKE: sh_ll");
            List c = this.getEntityManager().createQuery("select distinct Object(c) FROM Customer c, in(c.aliases) a WHERE a.alias LIKE 'sh\\_ll' escape '\\'").getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest31 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest32() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where line items are members of the orders");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o, LineItem l WHERE l MEMBER o.lineItemsCollection").getResultList();
            String[] expectedPKs = new String[this.orderRef.length];
            for (int i = 0; i < this.orderRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + this.orderRef.length + "references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest32 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest33() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find orders whose orders are do NOT contain the specified line items");
            LineItem liDvc = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"30");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o WHERE :param NOT MEMBER o.lineItemsCollection").setParameter("param", (Object)liDvc).getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 19 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest33 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest34() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find orders who have Samples in their orders");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o WHERE o.sampleLineItem MEMBER OF o.lineItemsCollection").getResultList();
            String[] expectedPKs = new String[]{"1", "6"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest34 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest35() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders which contain lineitems not of quantities 1 or 5");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) from Order o, in(o.lineItemsCollection) l where l.quantity NOT IN (1, 5)").getResultList();
            String[] expectedPKs = new String[]{"10", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 9 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest35 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest36() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who lives in city Attleboro");
            List c = this.getEntityManager().createQuery("SELECT c From Customer c where c.home.city IN(:city)").setParameter("city", (Object)"Attleboro").getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest36 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest37() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results");
            List c1 = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) from Customer c where c.home.state IN('NH', 'RI')").getResultList();
            String[] expectedPKs = new String[]{"5", "6", "12", "14", "16"};
            List c2 = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) from Customer c WHERE (c.home.state = 'NH') OR (c.home.state = 'RI')").getResultList();
            String[] expectedPKs2 = new String[]{"5", "6", "12", "14", "16"};
            if (!this.checkEntityPK(c1, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results for first query.  Expected 5 reference, got: " + c1.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(c2, expectedPKs2)) {
                TestUtil.logErr((String)("Did not get expected results for second query.  Expected 5 reference, got: " + c2.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest37 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest38() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing MOD with numeric Java object types");
            TestUtil.logTrace((String)"find orders that have the quantity of 50 available");
            Integer value1 = 550;
            Integer value2 = 100;
            List p = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where MOD(" + value1 + "," + value2 + ") = p.quantity").getResultList();
            String[] expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            TestUtil.logMsg((String)"Testing MOD with primitive numeric type");
            TestUtil.logTrace((String)"find orders that have the quantity of 50 available");
            p = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where MOD(550, 100) = p.quantity").getResultList();
            expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest38 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest39() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing SQRT with numeric Java object types");
            TestUtil.logTrace((String)"find customers with specific credit card balance");
            List c = this.getEntityManager().createQuery("Select Distinct OBJECT(c) from Customer c, IN(c.creditCards) b where SQRT(b.balance) = :dbl").setParameter("dbl", (Object)50.0).getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            TestUtil.logMsg((String)"Testing SQRT with primitive numeric type");
            TestUtil.logTrace((String)"find customers with specific credit card balance");
            c = this.getEntityManager().createQuery("Select Distinct OBJECT(c) from Customer c, IN(c.creditCards) b where SQRT(b.balance) = SQRT(:dbl)").setParameter("dbl", (Object)2500.0).getResultList();
            expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest39 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest40() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results Execute Query 1");
            List p1 = this.getEntityManager().createQuery("Select DISTINCT OBJECT(p) From Product p where p.quantity BETWEEN 10 AND 20").getResultList();
            String[] expectedPKs = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            TestUtil.logTrace((String)"Execute Query 2");
            List p2 = this.getEntityManager().createQuery("Select DISTINCT OBJECT(p) From Product p where (p.quantity >= 10) AND (p.quantity <= 20)").getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            if (!this.checkEntityPK(p1, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results for first query in queryTest40.   Expected 7 references, got: " + p1.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for first query in queryTest40.");
                pass1 = true;
            }
            if (!this.checkEntityPK(p2, expectedPKs2)) {
                TestUtil.logErr((String)("Did not get expected results for second query in queryTest40.   Expected 7 references, got: " + p2.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for second query in queryTest40.");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest40 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest41() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results Execute first query");
            List p1 = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where p.quantity NOT BETWEEN 20 AND 200").getResultList();
            String[] expectedPKs = new String[]{"8", "9", "10", "11", "14", "15", "17", "21", "29", "31"};
            if (!this.checkEntityPK(p1, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results for first query.  Expected 31 references, got: " + p1.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for first query");
                pass1 = true;
            }
            TestUtil.logTrace((String)"Execute second query");
            List p2 = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where (p.quantity < 20) OR (p.quantity > 200)").getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "10", "11", "14", "15", "17", "21", "29", "31"};
            if (!this.checkEntityPK(p2, expectedPKs2)) {
                TestUtil.logErr((String)("Did not get expected results for second query.  Expected 31 references, got: " + p2.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest41 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest42() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where related customer name is not null");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) from Order o where o.customer.name IS NOT NULL").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 19 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest42 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest43() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Check results of AND operator: False AND False = False");
            List p = this.getEntityManager().createQuery("Select Distinct Object(p) from Product p where (p.quantity > (500 + :int1)) AND (p.partNumber IS NULL)").setParameter("int1", (Object)100).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest43 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest44() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"provide a null value for a comparison operation and verify the results");
            List p = this.getEntityManager().createQuery("Select Distinct Object(p) from Product p where p.name = ?1").setParameter(1, null).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest44 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest45() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find customers whose id is greater than 1 OR where the relationship is NOT EMPTY");
            List c = this.getEntityManager().createQuery("Select Object(c) from Customer c where c.aliasesNoop IS NOT EMPTY or c.id <> '1'").getResultList();
            String[] expectedPKs = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 19 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest45 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest47() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find work zip codes that are not null");
            List c = this.getEntityManager().createQuery("Select c.work.zip from Customer c where c.work.zip IS NOT NULL ORDER BY c.work.zip ASC").getResultList();
            Object[] result = c.toArray(new String[c.size()]);
            TestUtil.logTrace((String)"Compare results of work zip codes");
            pass = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest47 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest48() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedBalances = new Double[]{400.0, 500.0, 750.0, 1000.0, 1400.0, 1500.0, 2000.0, 2500.0, 4400.0, 5000.0, 5500.0, 7000.0, 7400.0, 8000.0, 9500.0, 13000.0, 15000.0, 23000.0};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all credit card balances");
            List o = this.getEntityManager().createQuery("Select Distinct o.creditCard.balance from Order o ORDER BY o.creditCard.balance ASC").getResultList();
            Object[] result = o.toArray(new Double[o.size()]);
            Iterator i = o.iterator();
            while (i.hasNext()) {
                TestUtil.logTrace((String)("query results returned:  " + (Double)i.next()));
            }
            TestUtil.logTrace((String)"Compare expected results to query results");
            pass = Arrays.equals(expectedBalances, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest48 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest49() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who have a null relationship");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c, in(c.aliases) a WHERE a.customerNoop IS NULL").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 13 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest49 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest50() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers with an alias that contains an underscore");
            List c = this.getEntityManager().createQuery("select distinct Object(c) FROM Customer c, in(c.aliases) a WHERE a.alias LIKE '%\\_%' escape '\\'").getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest50 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest51() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who do not have null relationship");
            List c = this.getEntityManager().createQuery("sElEcT Distinct oBJeCt(c) FROM Customer c, IN(c.aliases) a WHERE a.customerNoop IS NOT NULL").getResultList();
            if (c.size() != 0) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest51 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest52() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine if customer has a NULL relationship");
            List c = this.getEntityManager().createQuery("select Distinct Object(c) from Customer c, in(c.aliases) a where c.name = :cName AND a.customerNoop IS NULL").setParameter("cName", (Object)"Shelly D. McGowan").getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest52 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest53() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine if customer has a NULL relationship");
            List c = this.getEntityManager().createQuery("select distinct object(c) fRoM Customer c, IN(c.aliases) a where c.name = :cName OR a.customerNoop IS NULL").setParameter("cName", (Object)"Arthur D. Frechette").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 13 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest53 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest54() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine if customers have a NULL relationship");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) from Customer c, in(c.aliases) a where NOT a.customerNoop IS NULL").getResultList();
            if (c.size() != 0) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest54 failed");
        }
    }

    @SetupMethod(name="setupPhoneData")
    public void queryTest55() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine which customers have an area code beginning with 9");
            List c = this.getEntityManager().createQuery("SELECT Distinct Object(c) From Customer c, IN(c.home.phones) p where p.area LIKE :area").setParameter("area", (Object)"9%").getResultList();
            String[] expectedPKs = new String[]{"3", "12", "16"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest55 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest56() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        String[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all work zip codes");
            List c = this.getEntityManager().createQuery("Select c.work.zip from Customer c").getResultList();
            if (c.size() != 18) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 18 references, got: " + c.size()));
            } else {
                Iterator i = c.iterator();
                int numOfNull = 0;
                int foundZip = 0;
                block2: while (i.hasNext()) {
                    pass1 = true;
                    TestUtil.logTrace((String)"Check contents of List for null");
                    Object o = i.next();
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    TestUtil.logTrace((String)"Check List for expected zip codes");
                    for (int l = 0; l < 17; ++l) {
                        if (!expectedZips[l].equals(o)) continue;
                        ++foundZip;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundZip != 17) {
                    TestUtil.logErr((String)"Did not get expected results");
                    pass2 = false;
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest56 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest58() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find home zip codes");
            Object s = this.getEntityManager().createQuery("Select c.name from Customer c where c.home.street = '212 Edgewood Drive'").getSingleResult();
            if (s != null) {
                TestUtil.logErr((String)"Did not get expected results.  Expected null.");
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest58 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest59() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine which customers have an null name");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) from Customer c where c.name is null").getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest59 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest60() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Customers with an Order");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) o").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 18 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest60 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest61() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("select Distinct c FROM Customer c LEFT OUTER JOIN c.work workAddress where workAddress.zip IS NULL").getResultList();
            String[] expectedPKs = new String[]{"13", "19", "20"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest61 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest62() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE SIZE(c.orders) >= 2").getResultList();
            String[] expectedPKs = new String[]{"4", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest62 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest63() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE SIZE(c.orders) > 100").getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest63 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest64() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("SELECT NEW com.sun.ts.tests.jpa.common.schema30.Customer (c.id, c.name, c.country, c.work) FROM Customer c where  c.work.city = :workcity").setParameter("workcity", (Object)"Burlington").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 18 references, got: " + c.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest64 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest65() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 1;
        try {
            Object result;
            TestUtil.logTrace((String)"select MINIMUM number of lineItem quantities available an order may have");
            Query q = this.getEntityManager().createQuery("SELECT DISTINCT MIN(l.quantity) FROM LineItem l");
            List i2 = q.getResultList();
            Query q1 = this.getEntityManager().createQuery("SELECT MIN(l.quantity) FROM LineItem l");
            List i3 = q1.getResultList();
            TestUtil.logMsg((String)"Verify select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass1 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i2) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
            TestUtil.logMsg((String)"Verify Select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass2 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i3) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest65 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest66() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 8;
        try {
            Object result;
            TestUtil.logTrace((String)"find MAXIMUM number of lineItem quantities available an order may have");
            Query q = this.getEntityManager().createQuery("SELECT DISTINCT MAX(l.quantity) FROM LineItem l");
            List i2 = q.getResultList();
            Query q1 = this.getEntityManager().createQuery("SELECT MAX(l.quantity) FROM LineItem l");
            List i3 = q1.getResultList();
            TestUtil.logMsg((String)"Testing select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass1 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i2) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
            TestUtil.logMsg((String)"Testing Select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass2 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i3) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest66 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest67() throws EETest.Fault {
        boolean pass = false;
        Double d1 = 1487.29;
        Double d2 = 1487.3;
        try {
            TestUtil.logTrace((String)"find AVERAGE price of all orders");
            Query q = this.getEntityManager().createQuery("SELECT AVG(o.totalPrice) FROM Order o");
            Double d3 = (Double)q.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logTrace((String)("Returned expected results: " + d1));
                pass = true;
            } else {
                TestUtil.logTrace((String)("Returned " + d3 + "expected: " + d1));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest67 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest68() throws EETest.Fault {
        boolean pass = false;
        Double d1 = 33387.14;
        Double d2 = 33387.15;
        try {
            TestUtil.logTrace((String)"find SUM of all product prices");
            Query q = this.getEntityManager().createQuery("SELECT Sum(p.price) FROM Product p");
            Double d3 = (Double)q.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logTrace((String)("Returned expected results: " + d1));
                pass = true;
            } else {
                TestUtil.logTrace((String)("Returned " + d3 + "expected: " + d1));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest68 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest69() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedResult1 = 17L;
        Long expectedResult2 = 16L;
        try {
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results");
            Query q1 = this.getEntityManager().createQuery("Select Count(c.home.city) from Customer c");
            Long result1 = (Long)q1.getSingleResult();
            if (!result1.equals(expectedResult1)) {
                TestUtil.logErr((String)("Query1 in queryTest69 returned:" + result1 + " expected: " + expectedResult1));
            } else {
                TestUtil.logTrace((String)"pass:  Query1 in queryTest69 returned expected results");
                pass1 = true;
            }
            Query q2 = this.getEntityManager().createQuery("Select Count(Distinct c.home.city) from Customer c");
            Long result2 = (Long)q2.getSingleResult();
            if (!result2.equals(expectedResult2)) {
                TestUtil.logErr((String)("Query 2 in queryTest69 returned:" + result2 + " expected: " + expectedResult2));
            } else {
                TestUtil.logTrace((String)"pass:  Query 2 in queryTest69 returned expected results");
                pass2 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest69 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest70() throws EETest.Fault {
        boolean pass = false;
        Long expectedValue = 3277L;
        try {
            TestUtil.logTrace((String)"find SUM of all product prices");
            Query q = this.getEntityManager().createQuery("SELECT Sum(p.quantity) FROM Product p");
            Long result = (Long)q.getSingleResult();
            if (expectedValue.equals(result)) {
                TestUtil.logTrace((String)("Returned expected results: " + result));
                pass = true;
            } else {
                TestUtil.logTrace((String)("Returned " + result + "expected: " + expectedValue));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception queryTest70: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest70 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest71() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Check if a spouse is related to a customer");
            this.getEntityManager().createQuery("Select s.customer from Spouse s where s.id = '7'").getSingleResult();
            this.getEntityTransaction().commit();
        }
        catch (NoResultException e) {
            TestUtil.logTrace((String)("queryTest71: NoResultException caught as expected : " + (Object)((Object)e)));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception caught in queryTest71: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("queryTest71 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_leftouterjoin_1xM() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c from Customer c LEFT OUTER JOIN c.creditCards cc where c.name LIKE '%Caruso'").getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_leftouterjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_leftouterjoin_Mx1() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"15", "14"}, {"16", "14"}};
        try {
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("SELECT o.id, cust.id from Order o LEFT OUTER JOIN o.customer cust where cust.name=?1 ORDER BY o.id").setParameter(1, (Object)"Kellie A. Sanborn").getResultList();
            if (q.size() != 2) {
                TestUtil.logTrace((String)("test_leftouterjoin_Mx1:  Did not get expected results. Expected 2,  got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    pass1 = true;
                    Object obj = q.get(i);
                    Object[] orderAndCustomerExpected = expectedResultSet[i];
                    if (obj instanceof Object[]) {
                        TestUtil.logTrace((String)"The element in the result list is of type Object[], continue . . .");
                        Object[] orderAndCustomer = (Object[])obj;
                        if (Arrays.equals(orderAndCustomerExpected, orderAndCustomer)) continue;
                        TestUtil.logErr((String)("Expecting element value: " + Arrays.asList(orderAndCustomerExpected) + ", actual element value: " + Arrays.asList(orderAndCustomer)));
                        pass2 = false;
                        break;
                    }
                    pass2 = false;
                    TestUtil.logErr((String)("The element in the result list is not of type Object[]:" + obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("test_leftouterjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_leftouterjoin_MxM() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"7", "sjc"}, {"5", "ssd"}, {"7", "stevec"}, {"5", "steved"}, {"5", "stevie"}, {"7", "stevie"}};
        try {
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("SELECT c.id, a.alias from Customer c LEFT OUTER JOIN c.aliases a where c.name LIKE 'Ste%' ORDER BY a.alias, c.id").getResultList();
            if (q.size() != 6) {
                TestUtil.logTrace((String)("test_leftouterjoin_MxM:  Did not get expected results. Expected 6,  got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    pass1 = true;
                    Object obj = q.get(i);
                    Object[] customerAndAliasExpected = expectedResultSet[i];
                    if (obj instanceof Object[]) {
                        TestUtil.logTrace((String)"The element in the result list is of type Object[], continue . . .");
                        Object[] customerAndAlias = (Object[])obj;
                        if (Arrays.equals(customerAndAliasExpected, customerAndAlias)) continue;
                        TestUtil.logErr((String)("Expecting element value: " + Arrays.asList(customerAndAliasExpected) + ", actual element value: " + Arrays.asList(customerAndAlias)));
                        pass2 = false;
                        break;
                    }
                    pass2 = false;
                    TestUtil.logErr((String)("The element in the result list is not of type Object[]:" + obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("test_leftouterjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_upperStringExpression() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(c) FROM Customer c JOIN c.aliases a where UPPER(a.alias)='SJC' ").getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception caught exception in test_upperStringExpression: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_upperStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_lowerStringExpression() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(c) FROM Customer c JOIN c.aliases a where LOWER(a.alias)='sjc' ").getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception caught exception in test_lowerStringExpression: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_lowerStringExpression failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupBy() throws EETest.Fault {
        boolean pass = false;
        Object[] expected = new String[]{"CHA", "GBR", "IRE", "JPN", "USA"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select c.country.code FROM Customer c GROUP BY c.country.code").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                TestUtil.logErr((String)"Did not get expected results");
                for (Object s : expected) {
                    TestUtil.logErr((String)("Expected:" + (String)s));
                }
                for (Object s : output) {
                    TestUtil.logErr((String)("Actual:" + (String)s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupBy failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupBy_1() throws EETest.Fault {
        boolean pass = false;
        Object[] expected = new String[]{"AXP", "MCARD", "VISA"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select cc.type FROM CreditCard cc JOIN cc.customer cust GROUP BY cc.type").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                TestUtil.logErr((String)"Did not get expected results");
                for (Object s : expected) {
                    TestUtil.logErr((String)("Expected:" + (String)s));
                }
                for (Object s : output) {
                    TestUtil.logErr((String)("Actual:" + (String)s));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupBy_1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_innerjoin_1x1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c from Customer c INNER JOIN c.spouse s").getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_1xM() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT object(c) from Customer c INNER JOIN c.creditCards cc where cc.type='VISA' ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "6", "7", "10", "14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 8 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_Mx1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Object(o) from Order o INNER JOIN o.customer cust where cust.name = ?1").setParameter(1, (Object)"Kellie A. Sanborn").getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_innerjoin_MxM() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Object(c) from Customer c INNER JOIN c.aliases a where a.alias = :aName ").setParameter("aName", (Object)"fish").getResultList();
            String[] expectedPKs = new String[]{"1", "2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_fetchjoin_1x1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c from Customer c JOIN FETCH c.spouse ").getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results. Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_1xM() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c from Customer c LEFT JOIN FETCH c.orders where c.home.state IN('NY','RI')").getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select o from Order o LEFT JOIN FETCH o.customer where o.customer.home.city='Lawrence'").getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 8 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1_1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) from Order o LEFT JOIN FETCH o.customer where o.customer.name LIKE '%Caruso' ").getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_Mx1_1 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_fetchjoin_MxM() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FETCHJOIN-MXM Executing Query");
            List result = this.getEntityManager().createQuery("SELECT DISTINCT a from Alias a LEFT JOIN FETCH a.customers where a.alias LIKE 'a%' ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void test_betweenDates() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date date1 = this.getSQLDate(2000, 2, 14);
            Date date6 = this.getSQLDate(2005, 2, 18);
            TestUtil.logTrace((String)("The dates used in test_betweenDates is : " + date1 + " and " + date6));
            List result = this.getEntityManager().createQuery("SELECT DISTINCT p From Product p where p.shelfLife.soldDate BETWEEN :date1 AND :date6").setParameter("date1", (Object)date1).setParameter("date6", (Object)date6).getResultList();
            String[] expectedPKs = new String[]{"31", "32", "33", "37"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_betweenDates failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_notBetweenArithmetic() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT o From Order o where o.totalPrice NOT BETWEEN 1000 AND 1200").getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_notBetweenArithmetic failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void test_notBetweenDates() throws EETest.Fault {
        boolean pass = false;
        Date date1 = this.getSQLDate("2000-02-14");
        Date newdate = this.getSQLDate("2005-02-17");
        TestUtil.logTrace((String)("The dates used in test_betweenDates is : " + date1 + " and " + newdate));
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT p From Product p where p.shelfLife.soldDate NOT BETWEEN :date1 AND :newdate").setParameter("date1", (Object)date1).setParameter("newdate", (Object)newdate).getResultList();
            String[] expectedPKs = new String[]{"31"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_notBetweenDates failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' AND o.totalPrice > 500").getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTF() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' AND o.totalPrice > 10000").getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.id = '1001' AND o.totalPrice < 1000 ").getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFF() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.id = '1001' AND o.totalPrice > 10000").getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select DISTINCT o FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' OR o.totalPrice > 5000").getResultList();
            String[] expectedPKs = new String[]{"6", "11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTF() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' OR o.totalPrice > 10000").getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Distinct Object(o) FROM Order AS o WHERE o.customer.id = '1001' OR o.totalPrice < 1000 ").getResultList();
            String[] expectedPKs = new String[]{"9", "10", "12", "13", "15", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFF() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.id = '1001' OR o.totalPrice > 10000").getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupByWhereClause() throws EETest.Fault {
        boolean pass = false;
        Object[] expected = new String[]{"Jonathan K. Smith", "Kellie A. Sanborn", "Robert E. Bissett"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select c.name FROM Customer c JOIN c.orders o WHERE o.totalPrice BETWEEN 90 AND 160 GROUP BY c.name").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                TestUtil.logErr((String)"Did not get expected results");
                for (Object s : expected) {
                    TestUtil.logErr((String)("Expected:" + (String)s));
                }
                for (Object s : output) {
                    TestUtil.logErr((String)("Actual:" + (String)s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupByWhereClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupByHaving() throws EETest.Fault {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Count(c) FROM Customer c GROUP BY c.country.code HAVING c.country.code IN ('GBR', 'CHA') ").getResultList();
            Iterator i = result.iterator();
            int numOfExpected = 0;
            while (i.hasNext()) {
                TestUtil.logTrace((String)"Check result received . . . ");
                Long l = (Long)i.next();
                if (!l.equals(expectedGBR) && !l.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected != 2) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size()));
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    TestUtil.logTrace((String)("count of Codes Returned: " + it.next()));
                }
            } else {
                TestUtil.logTrace((String)"Expected results received.");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupByHaving failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_substringHavingClause() throws EETest.Fault {
        boolean pass = false;
        Long expectedCount = 2L;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Executing Query");
            Query q = this.getEntityManager().createQuery("select count(c) FROM Customer c JOIN c.aliases a GROUP BY a.alias HAVING a.alias = SUBSTRING(:string1, :int1, :int2)").setParameter("string1", (Object)"fish").setParameter("int1", (Object)1).setParameter("int2", (Object)4);
            Long result = (Long)q.getSingleResult();
            TestUtil.logTrace((String)"Check results received .  .  .");
            if (expectedCount.equals(result)) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results. Expected Count of 2, got: " + result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_substringHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_concatHavingClause() throws EETest.Fault {
        boolean pass = false;
        String expectedCustomer = "Margaret Mills";
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select c.name FROM Customer c Group By c.name HAVING c.name = concat(:fmname, :lname) ").setParameter("fmname", (Object)"Margaret ").setParameter("lname", (Object)"Mills");
            String result = (String)q.getSingleResult();
            if (result.equals("Margaret Mills")) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logTrace((String)("test_concatHavingClause:  Did not get expected results. Expected: Margaret Mills, got: " + result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_concatHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lowerHavingClause() throws EETest.Fault {
        boolean pass = false;
        Long expectedCount = 2L;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select count(c.country.code) FROM Customer c GROUP BY c.country.code  HAVING LOWER(c.country.code) = 'gbr' ").getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                    continue;
                }
                TestUtil.logErr((String)("Did not get expected results. Expected 2 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_lowerHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_upperHavingClause() throws EETest.Fault {
        boolean pass = false;
        Long expectedCount = 2L;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select count(c.country.country) FROM Customer c GROUP BY c.country.country HAVING UPPER(c.country.country) = 'ENGLAND' ").getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                    continue;
                }
                TestUtil.logErr((String)("Did not get expected results. Expected 2 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_upperHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lengthHavingClause() throws EETest.Fault {
        boolean pass = false;
        Object[] expected = new String[]{"Burlington", "Chelmsford", "Roslindale"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select a.city  FROM Customer c JOIN c.home a GROUP BY a.city HAVING LENGTH(a.city) = 10 ").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                TestUtil.logErr((String)"Did not get expected result:");
                for (Object s : expected) {
                    TestUtil.logTrace((String)("expected:" + (String)s));
                }
                for (Object s : output) {
                    TestUtil.logTrace((String)("actual:" + (String)s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_lengthHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_locateHavingClause() throws EETest.Fault {
        boolean pass = false;
        Object[] expected = new String[]{"Alan E. Frechette", "Arthur D. Frechette"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select c.name FROM Customer c GROUP BY c.name HAVING LOCATE('Frechette', c.name) > 0 ").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                TestUtil.logErr((String)"Did not get expected result:");
                for (Object s : expected) {
                    TestUtil.logTrace((String)("expected:" + (String)s));
                }
                for (Object s : output) {
                    TestUtil.logTrace((String)("actual:" + (String)s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_locateHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ABSHavingClause() throws EETest.Fault {
        boolean pass = false;
        Double expectedPrice = 10191.9;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select sum(o.totalPrice) FROM Order o GROUP BY o.totalPrice HAVING ABS(o.totalPrice) = :doubleValue ").setParameter("doubleValue", (Object)5095.95);
            Double result = (Double)q.getSingleResult();
            if (expectedPrice.equals(result)) {
                pass = true;
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("test_ABSHavingClause:  Did not get expected results.Expected 10190, got: " + result));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ABSHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_SQRTWhereClause() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"SQRT: Executing Query");
            List result = this.getEntityManager().createQuery("select object(o) FROM Order o Where SQRT(o.totalPrice) > :doubleValue ").setParameter("doubleValue", (Object)70.0).getResultList();
            String[] expectedPKs = new String[]{"11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_SQRTWhereClause:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_SQRTWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_01() throws EETest.Fault {
        boolean pass = false;
        String[] expectedPKs = new String[]{"19", "20"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c WHERE NOT EXISTS (SELECT o1 FROM c.orders o1) ").getResultList();
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_exists_01:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_exists_01 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_02() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.totalPrice > 1500 ) ").getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_exists_02:  Did not get expected results.  Expected 4 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_exists_02 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_like() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("Select Object(o) from Order o WHERE EXISTS (Select c From o.customer c WHERE c.name LIKE '%Caruso') ").getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_like failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_subquery_in() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("Select DISTINCT c from Customer c WHERE c.home.state IN(Select distinct w.state from c.work w where w.state = :state ) ").setParameter("state", (Object)"MA").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_in failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_between() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute query for test_subquery_between");
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.totalPrice BETWEEN 1000 AND 1200)").getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_between:  Did not get expected  results.  Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_between failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_join() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c JOIN c.orders o WHERE EXISTS (SELECT o FROM o.lineItemsCollection l where l.quantity > 3 ) ").getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_join failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice > ALL (Select o.totalPrice FROM Order o, in(o.lineItemsCollection) l WHERE l.quantity > 3) ").getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_GT:  Did not get expected results.  Expected 4 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_ALL_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT distinct object(C) FROM Customer C, IN(C.orders) co WHERE co.totalPrice < ALL (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity > 3) ").getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_LT:  Did not get expected results.  Expected 1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_EQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice = ALL (Select MIN(o.totalPrice) FROM Order o) ").getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_EQ:  Did not get expected results.  Expected 1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LTEQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice <= ALL (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity > 3) ").getResultList();
            String[] expectedPKs = new String[]{"9", "12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_LTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GTEQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT object(c) FROM Customer C, IN(c.orders) co WHERE co.totalPrice >= ALL (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity >= 3) ").getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_GTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_GTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_NOTEQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice <> ALL (Select MIN(o.totalPrice) FROM Order o) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_NOTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_NOTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_GT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice > ANY (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ANY_GT:  Did not get expected results.   Expected 16 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ANY_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_LT() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct Object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice < ANY (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3)").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ANY_LT:  Did not get expected results.  Expected 17 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ANY_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_EQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice = ANY (Select MAX(o.totalPrice) FROM Order o) ").getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ANY_EQ:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ANY_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_LTEQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice <= SOME (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_SOME_LTEQ:  Did not get expected results.  Expected 18 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_SOME_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_GTEQ() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice >= SOME (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_SOME_GTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_SOME_GTEQ failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fetchStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c INNER JOIN fetch c.spouse").getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fetchStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void treatJoinClassTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[1].getName());
        expected.add(this.softwareRef[2].getName());
        expected.add(this.softwareRef[3].getName());
        expected.add(this.softwareRef[4].getName());
        expected.add(this.softwareRef[5].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT s.name FROM LineItem l JOIN TREAT(l.product AS SoftwareProduct) s").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                TestUtil.logTrace((String)("result:" + s));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result:");
                for (String s : expected) {
                    TestUtil.logTrace((String)("expected:" + s));
                }
                for (String s : actual) {
                    TestUtil.logTrace((String)("actual:" + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("treatJoinClassTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void treatInWhereClauseTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[7].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT p.name FROM Product p where TREAT(p AS SoftwareProduct).revisionNumber = 1.0").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                TestUtil.logTrace((String)("result:" + s));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result:");
                for (String s : expected) {
                    TestUtil.logTrace((String)("expected:" + s));
                }
                for (String s : actual) {
                    TestUtil.logTrace((String)("actual:" + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("treatInWhereClauseTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void appropriateSuffixesTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[7].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT p.name FROM Product p where TREAT(p AS SoftwareProduct).revisionNumber = 1.0D").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                TestUtil.logTrace((String)("result:" + s));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result:");
                for (String s : expected) {
                    TestUtil.logTrace((String)("expected:" + s));
                }
                for (String s : actual) {
                    TestUtil.logTrace((String)("actual:" + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("appropriateSuffixesTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void sqlApproximateNumericLiteralTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[7].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT p.name FROM Product p where TREAT(p AS SoftwareProduct).revisionNumber = 1E0").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                TestUtil.logTrace((String)("result:" + s));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected result:");
                for (String s : expected) {
                    TestUtil.logTrace((String)("expected:" + s));
                }
                for (String s : actual) {
                    TestUtil.logTrace((String)("actual:" + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("sqlApproximateNumericLiteralTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinOnExpressionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("select o FROM Order o INNER JOIN o.lineItemsCollection l ON (l.quantity > 5)").getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            for (Order o : actual) {
                TestUtil.logTrace((String)("order:" + o.getId() + ":"));
                Collection li = o.getLineItemsCollection();
                for (LineItem i : li) {
                    TestUtil.logTrace((String)("   item:" + i.getId() + ", " + i.getQuantity()));
                }
            }
            if (!this.checkEntityPK(actual, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void aggregateFunctionsWithNoValuesTest() throws EETest.Fault {
        Object o;
        Query q;
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Testing SUM");
            TestUtil.logTrace((String)"find SUM of all product prices");
            q = this.getEntityManager().createQuery("SELECT Sum(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                TestUtil.logTrace((String)"Returned expected null results");
                pass = true;
            } else {
                TestUtil.logErr((String)("Returned " + o.toString() + ", instead of null"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing AVG");
            TestUtil.logTrace((String)"find AVG of all product prices");
            q = this.getEntityManager().createQuery("SELECT AVG(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                TestUtil.logTrace((String)"Returned expected null results");
                pass = true;
            } else {
                TestUtil.logErr((String)("Returned " + o.toString() + ", instead of null"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing MAX");
            TestUtil.logTrace((String)"find MAX of all product prices");
            q = this.getEntityManager().createQuery("SELECT MAX(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                TestUtil.logTrace((String)"Returned expected null results");
                pass = true;
            } else {
                TestUtil.logErr((String)("Returned " + o.toString() + ", instead of null"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing MIN");
            TestUtil.logTrace((String)"find MIN of all product prices");
            q = this.getEntityManager().createQuery("SELECT MIN(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                TestUtil.logTrace((String)"Returned expected null results");
                pass = true;
            } else {
                TestUtil.logErr((String)("Returned " + o.toString() + ", instead of null"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing COUNT");
            TestUtil.logTrace((String)"find COUNT of all product prices");
            q = this.getEntityManager().createQuery("SELECT COUNT(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o != null) {
                if (o instanceof Long) {
                    Long i = (Long)o;
                    if (i == 0L) {
                        TestUtil.logTrace((String)"Returned expected 0 result");
                        pass = true;
                    }
                } else {
                    TestUtil.logErr((String)"Did not get instance of Long");
                }
            } else {
                TestUtil.logErr((String)"Received null instead of 0");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("aggregateFunctionsWithNoValuesTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void primaryKeyJoinColumnTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("Select p from Product p where p.wareHouse = 'WH5'").getResultList();
            if (actual.size() == 1 && ((Product)actual.get(0)).getWareHouse().equals("WH5")) {
                TestUtil.logTrace((String)("Expected results received:" + ((Product)actual.get(0)).getWareHouse()));
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned: " + ((Product)actual.get(0)).getWareHouse() + ", expected: WH5"));
                for (Product p : actual) {
                    TestUtil.logErr((String)("**id=" + p.getId() + ", model=" + p.getWareHouse()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void typeTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (HardwareProduct p : this.hardwareRef) {
            expected.add(Integer.valueOf(p.getId()));
        }
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        this.getEntityTransaction().begin();
        List result = this.getEntityManager().createQuery("Select p from Product p where TYPE(p) = HardwareProduct").getResultList();
        for (HardwareProduct p : result) {
            actual.add(Integer.parseInt(p.getId()));
        }
        Collections.sort(actual);
        if (!this.checkEntityPK(actual, expected)) {
            TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
        } else {
            TestUtil.logTrace((String)"Expected results received");
            pass = true;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryVariableOverridesQueryVariableTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c WHERE c.id in (SELECT c.id FROM Order c where c.id='10' ) ").getResultList();
            String[] expectedPKs = new String[]{"10"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Expected 1 result, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("subqueryVariableOverridesQueryVariableTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void longIdentifierNameTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Orders for Customer: Robert E. Bissett");
            List o = this.getEntityManager().createQuery("Select Distinct variable01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789 from Order variable01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789 WHERE variable01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789.customer.name = :name").setParameter("name", (Object)"Robert E. Bissett").getResultList();
            if (o.size() > 0) {
                for (Object oo : o) {
                    if (oo instanceof Order) continue;
                    TestUtil.logErr((String)("Object returned was not of type Order:" + oo.getClass().getName()));
                    pass2 = false;
                }
            } else {
                TestUtil.logErr((String)"Not results were returned");
                pass2 = false;
            }
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("longIdentifierNameTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void underscoreIdentifierNameTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Orders for Customer: Robert E. Bissett");
            String variable = "_01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            if (this.checkIdentifierValues(variable)) {
                TestUtil.logTrace((String)"Identifier is valid");
                pass1 = true;
            } else {
                TestUtil.logTrace((String)("Identifier[" + variable + "] is invalid"));
            }
            String sQuery = "Select Distinct " + variable + " from Order " + variable + " WHERE " + variable + ".customer.name = :name";
            TestUtil.logTrace((String)("Query=" + sQuery));
            List o = this.getEntityManager().createQuery(sQuery).setParameter("name", (Object)"Robert E. Bissett").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("underscoreIdentifierNameTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void dollarsignIdentifierNameTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Orders for Customer: Robert E. Bissett");
            String variable = "$01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            if (this.checkIdentifierValues(variable)) {
                TestUtil.logTrace((String)"Identifier is valid");
                pass1 = true;
            } else {
                TestUtil.logTrace((String)("Identifier[" + variable + "] is invalid"));
            }
            String sQuery = "Select Distinct " + variable + " from Order " + variable + " WHERE " + variable + ".customer.name = :name";
            TestUtil.logTrace((String)("Query=" + sQuery));
            List o = this.getEntityManager().createQuery(sQuery).setParameter("name", (Object)"Robert E. Bissett").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("dollarsignIdentifierNameTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void entityTypeLiteralTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Products");
            List p = this.getEntityManager().createQuery("Select p From Product p where TYPE(p) in (SoftwareProduct)").getResultList();
            String[] expectedPKs = new String[this.softwareRef.length];
            int i = 0;
            for (SoftwareProduct sf : this.softwareRef) {
                expectedPKs[i++] = sf.getId();
            }
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("entityTypeLiteralTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void scalarExpressionsTest() throws EETest.Fault {
        String[] expectedPKs;
        List p;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select p From Product p where ((p.quantity) + 10 < 25)").getResultList();
            expectedPKs = new String[]{"8", "9", "15", "17", "21"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Testing string expression:");
            p = this.getEntityManager().createQuery("Select p From Product p where (p.name like 'Java%')").getResultList();
            expectedPKs = new String[]{"1", "2", "20", "34"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("scalarExpressionsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void distinctNotSpecifiedTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All customer ids from Orders");
            List o = this.getEntityManager().createQuery("Select o.customer.id from Order AS o ").getResultList();
            Integer[] expectedPKs = new Integer[]{Integer.parseInt("1"), Integer.parseInt("2"), Integer.parseInt("3"), Integer.parseInt("4"), Integer.parseInt("4"), Integer.parseInt("5"), Integer.parseInt("6"), Integer.parseInt("7"), Integer.parseInt("8"), Integer.parseInt("9"), Integer.parseInt("10"), Integer.parseInt("11"), Integer.parseInt("12"), Integer.parseInt("13"), Integer.parseInt("14"), Integer.parseInt("14"), Integer.parseInt("15"), Integer.parseInt("16"), Integer.parseInt("17"), Integer.parseInt("18")};
            if (!this.checkEntityPK(o, expectedPKs, true, true)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("distinctNotSpecifiedTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void resultVariableTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List o = this.getEntityManager().createQuery("Select o.id AS OID from Order o WHERE (o.totalPrice < 100.0) ORDER BY OID").getResultList();
            Integer[] expectedPKs = new Integer[]{Integer.parseInt("9"), Integer.parseInt("10"), Integer.parseInt("12"), Integer.parseInt("13")};
            if (!this.checkEntityPK(o, expectedPKs, true, true)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + o.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("resultVariableTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void embeddableNotManagedTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("SELECT c, c.country FROM Customer c where c.home.city = :homecity").setParameter("homecity", (Object)"Bedford").getResultList();
            if (q.size() == 1) {
                for (Object[] o : q) {
                    TestUtil.logMsg((String)"Testing initial values");
                    Customer cust = (Customer)o[0];
                    Country country = (Country)o[1];
                    TestUtil.logTrace((String)("Customer:" + cust.toString()));
                    TestUtil.logTrace((String)("Country:" + country.toString()));
                    if (cust.getCountry() != country) {
                        TestUtil.logTrace((String)"Customer country object does not equal Country from query as expected");
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)"Customer country object equals Country from query");
                    }
                    TestUtil.logMsg((String)"Change values of country");
                    country.setCode("CHA");
                    country.setCountry("China");
                    TestUtil.logTrace((String)("Customer:" + cust.toString()));
                    TestUtil.logTrace((String)("Country:" + country.toString()));
                    TestUtil.logTrace((String)"Flush and refresh");
                    this.getEntityManager().flush();
                    this.getEntityManager().refresh((Object)cust);
                    TestUtil.logMsg((String)"Test values again");
                    TestUtil.logTrace((String)("Customer:" + cust.toString()));
                    TestUtil.logTrace((String)("Country:" + country.toString()));
                    if (cust.getCountry() != country) {
                        if (!cust.getCountry().getCountry().equals("China") && !cust.getCountry().getCode().equals("CHA")) {
                            TestUtil.logTrace((String)"Customer.country does not contain the modifications made to the Country object");
                            pass2 = true;
                            continue;
                        }
                        TestUtil.logErr((String)"Customer.country contains the modifications made to the Country object");
                        continue;
                    }
                    TestUtil.logErr((String)"Customer country object equals Country from query");
                }
            } else {
                TestUtil.logErr((String)("Did not get 1 result back:" + q.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("embeddableNotManagedTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void resultContainsFetchReference() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        List result = this.getEntityManager().createQuery("SELECT d FROM Department d LEFT JOIN FETCH d.lastNameEmployees WHERE d.id = 1").getResultList();
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(this.deptRef[0].getId());
        if (result.size() == 1) {
            ArrayList<Integer> actual = new ArrayList<Integer>();
            actual.add(((Department)result.get(0)).getId());
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"More than 1 result got returned:");
            for (Department dept : result) {
                TestUtil.logErr((String)("Dept:" + dept.toString()));
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("resultContainsFetchReference test failed");
        }
    }

    private boolean checkIdentifierValues(String var) {
        boolean pass = true;
        TestUtil.logMsg((String)"Testing that identifier is valid");
        char[] c = var.toCharArray();
        boolean first = true;
        for (char cc : c) {
            if (first) {
                if (!Character.isJavaIdentifierStart(cc)) {
                    TestUtil.logErr((String)("Value[" + cc + "is not a valid start character"));
                    pass = false;
                }
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(cc)) continue;
            TestUtil.logErr((String)("Value[" + cc + "is not a valid part character"));
            pass = false;
        }
        return pass;
    }
}

