/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.bigdecimal;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.bigdecimal.A;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest1");
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("1", "a1", 1, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest2");
        boolean pass = false;
        A aRef = null;
        try {
            TestUtil.logTrace((String)"new A");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            aRef = new A("2", "a2", 2, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            A newA = this.findA(bigDecimal);
            if (newA != null) {
                TestUtil.logTrace((String)"A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA(bigDecimal));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest3");
        Object aName = null;
        boolean pass = false;
        A result = null;
        A a1 = null;
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            a1 = new A("3", "a3", 3, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            TestUtil.logTrace((String)"Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"find By Name");
            result = (A)this.findByName("a3");
            TestUtil.logTrace((String)"Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest4");
        boolean pass = false;
        A aRef = null;
        try {
            TestUtil.logTrace((String)"Persist Instance");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            aRef = new A("4", "a4", 4, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findA(bigDecimal))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, try to persist again ");
                    A newA = this.findA(bigDecimal);
                    this.getEntityManager().persist((Object)newA);
                    TestUtil.logTrace((String)"Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to persist an already persisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest5");
        A a2 = null;
        A aRef = null;
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            aRef = new A("5", "a5", 5, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findA(bigDecimal))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, try to change name and flush ");
                    a2 = this.findA(bigDecimal);
                    a2.setName("a2");
                    this.getEntityManager().flush();
                    if (a2.getName().equals("a2")) {
                        TestUtil.logTrace((String)"sync to database successful");
                        pass = true;
                    }
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to flush apersisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest5 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(BigDecimal id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        TestUtil.logTrace((String)"Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BIGDECIMAL").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

