/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt6;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class callStmtClient6
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt6";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private ResultSet rs = null;

    public static void main(String[] args) {
        callStmtClient6 theTests = new callStmtClient6();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString01() throws EETest.Fault {
        String minStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Name(?)}");
            this.msg.setMsg("extract the Minimum Value be Updated");
            minStringVal = this.rsSch.extractVal("Char_Tab", 2, this.sqlp, this.conn);
            minStringVal = minStringVal.substring(1, minStringVal.length() - 1);
            this.cstmt.setString(1, minStringVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Max_Val_Query = this.sqlp.getProperty("Char_Query_Name", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            this.msg.addOutputMsg(minStringVal, rStringVal);
            if (rStringVal.trim().equals(minStringVal.trim())) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "test setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString02() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.msg.setMsg(" extract the Maximum Value of int to be Updated");
            maxStringVal = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("String Value :" + maxStringVal);
            this.cstmt.setString(1, maxStringVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.trim().equals(maxStringVal.trim())) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "test setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString03() throws EETest.Fault {
        String minStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Name(?)}");
            this.msg.setMsg("to extract the Minimum Value of int to be Updated");
            minStringVal = this.rsSch.extractVal("Varchar_Tab", 2, this.sqlp, this.conn);
            minStringVal = minStringVal.substring(1, minStringVal.length() - 1);
            this.msg.setMsg("String Value :" + minStringVal);
            this.cstmt.setString(1, minStringVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Max_Val_Query = this.sqlp.getProperty("Varchar_Query_Name", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            this.msg.addOutputMsg(minStringVal, rStringVal);
            if (rStringVal.trim().equals(minStringVal.trim())) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "test setString Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString04() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.msg.setMsg("to extract the Maximum Value of int to be Updated");
            maxStringVal = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("String Value :" + maxStringVal);
            this.cstmt.setString(1, maxStringVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.trim().equals(maxStringVal.trim())) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "test setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString05() throws EETest.Fault {
        String minStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Name(?)}");
            this.msg.setMsg("to extract the Minimum Value of int to be Updated");
            minStringVal = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            minStringVal = minStringVal.substring(1, minStringVal.length() - 1);
            this.msg.setMsg("String Value :" + minStringVal);
            this.cstmt.setString(1, minStringVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Max_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Name", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            InputStream is = this.rs.getAsciiStream(1);
            System.out.println("AsciiStream Created");
            BufferedReader d = new BufferedReader(new InputStreamReader(is));
            System.out.println("BufferedReader Stream Created");
            rStringVal = d.readLine();
            this.msg.addOutputMsg(minStringVal, rStringVal);
            if (rStringVal.trim().equals(minStringVal.trim())) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "test setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString06() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.msg.setMsg("to extract the Maximum Value of int to be Updated");
            maxStringVal = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("String Value :" + maxStringVal);
            this.cstmt.setString(1, maxStringVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            InputStream is = this.rs.getAsciiStream(1);
            System.out.println("AsciiStream Created");
            BufferedReader d = new BufferedReader(new InputStreamReader(is));
            System.out.println("BufferedReader Stream Created");
            rStringVal = d.readLine();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.trim().equals(maxStringVal.trim())) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "test setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBigDecimal01() throws EETest.Fault {
        BigDecimal oRetVal = null;
        BigDecimal oExtVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            String sminStringVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            oExtVal = new BigDecimal(sminStringVal);
            this.msg.setMsg("Minimum decimal Value to be updated :" + oExtVal);
            this.cstmt.setBigDecimal(1, oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Decimal_Query_Max", "");
            this.msg.setMsg("Query String :" + Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            oRetVal = this.rs.getBigDecimal(1);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("setBigDecimal set the Minimum value " + oRetVal);
            } else {
                this.msg.printTestError("setBigDecimal did not set the Minimum value", "test setBigDecimal is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBigDecimal Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBigDecimal02() throws EETest.Fault {
        BigDecimal oRetVal = null;
        BigDecimal oExtVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Null(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            String smaxStringVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            oExtVal = new BigDecimal(smaxStringVal);
            this.msg.setMsg("Maximum decimal Value to be updated :" + oExtVal);
            this.cstmt.setBigDecimal(1, oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg("Query String :" + Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            oRetVal = this.rs.getBigDecimal(1);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("setBigDecimal sets the Maximum value ");
            } else {
                this.msg.printTestError("setBigDecimal did not set the Maximum value", "test setBigDecimal is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBigDecimal Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBigDecimal03() throws EETest.Fault {
        BigDecimal oRetVal = null;
        BigDecimal oExtVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            String sminStringVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            oExtVal = new BigDecimal(sminStringVal);
            this.msg.setMsg("Minimum Numeric Value to be updated :" + oExtVal);
            this.cstmt.setBigDecimal(1, oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Numeric_Query_Max", "");
            this.msg.setMsg("Query String :" + Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            oRetVal = this.rs.getBigDecimal(1);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("setBigDecimal set the Minimum value " + oRetVal);
            } else {
                this.msg.printTestError("setBigDecimal did not set the Minimum value", "test setBigDecimal is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBigDecimal Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBigDecimal04() throws EETest.Fault {
        BigDecimal oRetVal = null;
        BigDecimal oExtVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Null(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            String smaxStringVal = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            oExtVal = new BigDecimal(smaxStringVal);
            this.msg.setMsg("Maximum decimal Value to be updated :" + oExtVal);
            this.cstmt.setBigDecimal(1, oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg("Query String :" + Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            oRetVal = this.rs.getBigDecimal(1);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("setBigDecimal set the Maximum value " + oRetVal);
            } else {
                this.msg.printTestError("setBigDecimal did not set the Maximum value", "test setBigDecimal is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBigDecimal Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBoolean01() throws EETest.Fault {
        Boolean oRetVal = null;
        Boolean oExtVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            oExtVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("Minimum Boolean Value to be updated :" + oExtVal);
            this.cstmt.setBoolean(1, (boolean)oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Bit_Query_Max", "");
            this.msg.setMsg("Query String :" + Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            boolean bRetVal = this.rs.getBoolean(1);
            oRetVal = new Boolean(bRetVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("setBoolean set the Minimum value " + oRetVal);
            } else {
                this.msg.printTestError("setBoolean did not set the Minimum value", "test setBoolean is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBoolean Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBoolean Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBoolean02() throws EETest.Fault {
        Boolean oRetVal = null;
        Boolean oExtVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_In_Null(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            oExtVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("Maximum Boolean Value to be updated :" + oExtVal);
            this.cstmt.setBoolean(1, (boolean)oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bit_Query_Null", "");
            this.msg.setMsg("Query String :" + Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            boolean bRetVal = this.rs.getBoolean(1);
            oRetVal = new Boolean(bRetVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("setBoolean set the Maximum value " + oRetVal);
            } else {
                this.msg.printTestError("setBoolean did not set the Maximum value", "test setBoolean is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBoolean Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBoolean Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetByte01() throws EETest.Fault {
        Byte oRetVal = null;
        Byte oExtVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            String sminStringVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            oExtVal = new Byte(sminStringVal);
            this.msg.setMsg("Minimum Byte Value to be updated :" + oExtVal);
            byte bExtVal = oExtVal;
            this.cstmt.setByte(1, bExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Tinyint_Query_Max", "");
            this.msg.setMsg("Query String :" + Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            byte bRetVal = this.rs.getByte(1);
            oRetVal = new Byte(bRetVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("setByte set the Minimum value " + oRetVal);
            } else {
                this.msg.printTestError("setByte did not set the Minimum value", "test setByte is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setByte Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setByte Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetByte02() throws EETest.Fault {
        Byte oRetVal = null;
        Byte oExtVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_In_Null(?)}");
            this.msg.setMsg("to extract the Minimum Value to be Updated");
            String smaxStringVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            oExtVal = new Byte(smaxStringVal);
            this.msg.setMsg("Maximum Byte Value to be updated :" + oExtVal);
            byte bExtVal = oExtVal;
            this.cstmt.setByte(1, bExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg("Query String :" + Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            byte bRetVal = this.rs.getByte(1);
            oRetVal = new Byte(bRetVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("setByte set the Maximum value " + oRetVal);
            } else {
                this.msg.printTestError("setByte did not set the Maximum value", "test setByte is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setByte Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setByte Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetShort01() throws EETest.Fault {
        String minStringVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value of Smallint to be Updated");
            sminStringVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            short minShortVal = Short.parseShort(sminStringVal);
            this.msg.setMsg("Minimum Smallint Value to be updated :" + minShortVal);
            this.cstmt.setShort(1, minShortVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Max_Val_Query = this.sqlp.getProperty("Smallint_Query_Max", "");
            this.msg.setMsg("Msg(Max_Val_Query);");
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            short rShortVal = this.rs.getShort(1);
            this.msg.addOutputMsg("" + minShortVal, "" + rShortVal);
            if (rShortVal == minShortVal) {
                this.msg.setMsg("setShort Method sets the designated parameter to a Short value ");
            } else {
                this.msg.printTestError("setShort Method does not set the designated parameter to a Short value ", "test setShort is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setShort Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setShort Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetShort02() throws EETest.Fault {
        String maxStringVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_In_Null(?)}");
            this.msg.setMsg("to extract the Maximum Value of Smallint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            short maxShortVal = Short.parseShort(smaxStringVal);
            this.msg.setMsg("Maximum Smallint Value to be updated :" + maxShortVal);
            this.cstmt.setShort(1, maxShortVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            short rShortVal = this.rs.getShort(1);
            this.msg.addOutputMsg("" + maxShortVal, "" + rShortVal);
            if (rShortVal == maxShortVal) {
                this.msg.setMsg("setShort Method sets the designated parameter to a Short value ");
            } else {
                this.msg.printTestError("setShort Method does not set the designated parameter to a Short value ", "test setShort is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setShort Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setShort Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetInt01() throws EETest.Fault {
        String minStringVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value of int to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            int minIntegerVal = Integer.parseInt(sminStringVal);
            this.msg.setMsg("Minimum int Value to be updated :" + minIntegerVal);
            this.cstmt.setInt(1, minIntegerVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Max_Val_Query = this.sqlp.getProperty("Integer_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            int rIntegerVal = this.rs.getInt(1);
            this.msg.addOutputMsg("" + minIntegerVal, "" + rIntegerVal);
            if (rIntegerVal == minIntegerVal) {
                this.msg.setMsg("setInt Method sets the designated parameter to a int value ");
            } else {
                this.msg.printTestError("setInt Method does not set the designated parameter to a int value ", "test setInt is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setInt Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setInt Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetInt02() throws EETest.Fault {
        String maxStringVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_In_Null(?)}");
            this.msg.setMsg("to extract the Maximum Value of int to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            int maxIntegerVal = Integer.parseInt(smaxStringVal);
            this.msg.setMsg("Maximum int Value to be updated :" + maxIntegerVal);
            this.cstmt.setInt(1, maxIntegerVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            int rIntegerVal = this.rs.getInt(1);
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rIntegerVal);
            if (rIntegerVal == maxIntegerVal) {
                this.msg.setMsg("setInt Method sets the designated parameter to a int value ");
            } else {
                this.msg.printTestError("setInt Method does not set the designated parameter to a int value ", "test setByte is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setInt Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setInt Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetLong01() throws EETest.Fault {
        String minStringVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value of int to be Updated");
            sminStringVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            long minLongVal = Long.parseLong(sminStringVal);
            this.msg.setMsg("Minimum long Value to be updated :" + minLongVal);
            this.cstmt.setLong(1, minLongVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Max_Val_Query = this.sqlp.getProperty("Bigint_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            long rLongVal = this.rs.getLong(1);
            this.msg.addOutputMsg("" + minLongVal, "" + rLongVal);
            if (rLongVal == minLongVal) {
                this.msg.setMsg("setLong Method sets the designated parameter to a long value ");
            } else {
                this.msg.printTestError("setLong Method does not set the designated parameter to a long value ", "test setLong is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setLong Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setLong Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetLong02() throws EETest.Fault {
        String maxStringVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_In_Null(?)}");
            this.msg.setMsg("to extract the Maximum Value of int to be Updated");
            smaxStringVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            long maxLongVal = Long.parseLong(smaxStringVal);
            this.msg.setMsg("Maximum long Value to be updated :" + maxLongVal);
            this.cstmt.setLong(1, maxLongVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            long rLongVal = this.rs.getLong(1);
            this.msg.addOutputMsg("" + maxLongVal, "" + rLongVal);
            if (rLongVal == maxLongVal) {
                this.msg.setMsg("setLong Method sets the designated parameter to a long value ");
            } else {
                this.msg.printTestError("setLong Method does not set the designated parameter to a long value ", "test setLong is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setLong Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setLong Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

