/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.altDD;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.assembly.altDD.PainterBean;
import com.sun.ts.tests.assembly.altDD.PainterBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String prefix = "java:comp/env/";
    private static final String entryLookup = "java:comp/env/myCountry";
    private static final String beanLookup = "java:comp/env/ejb/myPainter";
    private static final String entryNameRef = "France";
    private static final String beanNameRef = "Gaughin";
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            this.logTrace("[Client] Getting Naming Context...");
            this.nctx = new TSNamingContext();
            this.logTrace("[Client] Setup completed!");
        }
        catch (Exception e) {
            this.logErr("[Client] Failed to obtain Naming Context:" + e);
            throw new EETest.Fault("[Client] Setup failed:" + e, e);
        }
    }

    public void testAppClient() throws EETest.Fault {
        Object home = null;
        Object bean = null;
        boolean pass = false;
        try {
            this.logTrace("[Client] Looking up java:comp/env/myCountry");
            String entryValue = (String)this.nctx.lookup(entryLookup);
            pass = entryValue.equals(entryNameRef);
            if (!pass) {
                this.logErr("[Client] Expected java:comp/env/myCountry name to be France, not " + entryValue);
                throw new EETest.Fault("Alternative DD test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: " + e);
            throw new EETest.Fault("Alternative DD test failed!" + e, e);
        }
    }

    public void testEJB() throws EETest.Fault {
        PainterBeanHome home = null;
        PainterBean bean = null;
        boolean pass = false;
        try {
            this.logTrace("[Client] Looking up java:comp/env/ejb/myPainter");
            home = (PainterBeanHome)this.nctx.lookup(beanLookup, PainterBeanHome.class);
            bean = home.create();
            bean.initLogging(this.props);
            this.logTrace("[Client] Checking referenced EJB...");
            String nameValue = bean.whoAreYou();
            pass = nameValue.equals(beanNameRef);
            if (!pass) {
                this.logErr("[Client] Expected java:comp/env/ejb/myPainter name to be Gaughin, not " + nameValue);
                throw new EETest.Fault("Alternative DD test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: " + e);
            throw new EETest.Fault("Alternative DD test failed!" + e, e);
        }
        finally {
            try {
                if (null != bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logTrace((String)("[Client] Ignoring exception on  bean remove: " + e));
            }
        }
    }

    public void cleanup() {
        this.logTrace("[Client] Cleanup.");
    }
}

