/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.ADVC;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.BDVC;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.Bean;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.BeanHome;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends EETest {
    private static final String bean = "java:comp/env/ejb/Bean";
    private Bean bRef = null;
    private BeanHome bHome = null;
    private TSNamingContext nctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/Bean");
            this.bHome = (BeanHome)this.nctx.lookup(bean, BeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void dumpCollectionDataA(Collection c) {
        this.logMsg("Collection Data");
        this.logMsg("---------------");
        this.logMsg("- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            ADVC v = (ADVC)i.next();
            this.logMsg("- Element #" + elem++);
            this.logMsg("  id=" + v.getId() + ", name=" + v.getName() + ", value=" + v.getValue());
        }
    }

    private void dumpCollectionDataB(Collection c) {
        this.logMsg("Collection Data");
        this.logMsg("---------------");
        this.logMsg("- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            BDVC v = (BDVC)i.next();
            this.logMsg("- Element #" + elem++);
            this.logMsg("  id=" + v.getId() + ", name=" + v.getName() + ", value=" + v.getValue());
        }
    }

    public void btob_1xM_bi_test0() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 0);
            this.bRef.init(this.props);
            if (this.bRef.test0()) {
                TestUtil.logMsg((String)"relationship fields are empty or null - expected");
            } else {
                TestUtil.logErr((String)"relationship fields are not empty or null - unexpected");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test0 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test0 failed");
        }
    }

    public void btob_1xM_bi_test0a() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 1);
            this.bRef.init(this.props);
            if (this.bRef.test0()) {
                TestUtil.logMsg((String)"relationship fields are empty or null - expected");
            } else {
                TestUtil.logErr((String)"relationship fields are not empty or null - unexpected");
                pass = false;
            }
            TestUtil.logMsg((String)"Attempting to set collection cmr-field to null");
            pass = this.bRef.setCmrFieldToNull();
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test0a failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test0a failed");
        }
    }

    public void btob_1xM_bi_test0b() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 0);
            this.bRef.init(this.props);
            TestUtil.logMsg((String)"Attempting to set collection cmr-fields to wrong type");
            pass = this.bRef.setCmrFieldToWrongType(1);
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test0b failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test0b failed");
        }
    }

    public void btob_1xM_bi_test0c() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 0);
            this.bRef.init(this.props);
            TestUtil.logMsg((String)"Attempting to set collection cmr-fields to wrong type");
            pass = this.bRef.setCmrFieldToWrongType(2);
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test0c failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test0c failed");
        }
    }

    public void btob_1xM_bi_test1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create A and B EntityBean Objects");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b11 = new BDVC("11", "b11", 11);
            BDVC b12 = new BDVC("12", "b12", 12);
            ADVC a2 = new ADVC("2", "a2", 2);
            BDVC b21 = new BDVC("21", "b21", 21);
            BDVC b22 = new BDVC("22", "b22", 22);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b11, b12, a2, b21, b22);
            this.bRef.init(this.props);
            pass = this.bRef.doAssignmentTest1();
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test1 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test1 failed");
        }
    }

    public void btob_1xM_bi_test2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create A and B EntityBean Objects");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b11 = new BDVC("11", "b11", 11);
            BDVC b12 = new BDVC("12", "b12", 12);
            ADVC a2 = new ADVC("2", "a2", 2);
            BDVC b21 = new BDVC("21", "b21", 21);
            BDVC b22 = new BDVC("22", "b22", 22);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b11, b12, a2, b21, b22);
            this.bRef.init(this.props);
            pass = this.bRef.doAssignmentTest2();
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test2 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test2 failed");
        }
    }

    public void btob_1xM_bi_test3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create A and B EntityBean Objects");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b11 = new BDVC("11", "b11", 11);
            BDVC b12 = new BDVC("12", "b12", 12);
            ADVC a2 = new ADVC("2", "a2", 2);
            BDVC b21 = new BDVC("21", "b21", 21);
            BDVC b22 = new BDVC("22", "b22", 22);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b11, b12, a2, b21, b22);
            this.bRef.init(this.props);
            pass = this.bRef.doAssignmentTest3();
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test3 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test3 failed");
        }
    }

    public void btob_1xM_bi_test4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create A and B EntityBean Objects");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b11 = new BDVC("11", "b11", 11);
            BDVC b12 = new BDVC("12", "b12", 12);
            ADVC a2 = new ADVC("2", "a2", 2);
            BDVC b21 = new BDVC("21", "b21", 21);
            BDVC b22 = new BDVC("22", "b22", 22);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b11, b12, a2, b21, b22);
            this.bRef.init(this.props);
            pass = this.bRef.doAssignmentTest4();
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test4 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test4 failed");
        }
    }

    public void btob_1xM_bi_test5() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create A and B EntityBean Objects");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b11 = new BDVC("11", "b11", 11);
            BDVC b12 = new BDVC("12", "b12", 12);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b11, b12, null, null, null);
            this.bRef.init(this.props);
            Vector<BDVC> b = new Vector<BDVC>();
            b.add(new BDVC("11", "b11", 11));
            b.add(new BDVC("12", "b12", 12));
            this.logMsg("Getting B info from entitybean object A");
            Collection bInfo = this.bRef.getBInfoFromA();
            this.logMsg("Dumping B info ...");
            this.dumpCollectionDataB(bInfo);
            Vector<ADVC> a = new Vector<ADVC>();
            a.add(new ADVC("1", "a1", 1));
            this.logMsg("Getting A info from entitybean object B");
            Collection aInfo = this.bRef.getAInfoFromB();
            this.dumpCollectionDataA(aInfo);
            if (!bInfo.containsAll(b) || !aInfo.containsAll(a)) {
                pass = false;
                this.logErr("DataMismatch error");
                if (!bInfo.containsAll(b)) {
                    this.logErr("bInfo does not match expected results");
                }
                if (!aInfo.containsAll(a)) {
                    this.logErr("aInfo does not match expected results");
                }
            } else {
                this.logMsg("Data matches as expected");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1xM_bi_test5 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1xM_bi_test5 failed");
        }
    }
}

