/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet11;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class resultSetClient11
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet11";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient11 theTests = new resultSetClient11();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte22() throws EETest.Fault {
        String str = null;
        BigDecimal bigDecimalVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String Max_Val_Query = this.sqlp.getProperty("Decimal_Query_Max", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Decimal_Tab_Max_Update", null);
            bigDecimalVal = new BigDecimal(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setBigDecimal(1, bigDecimalVal);
            this.pstmt.executeUpdate();
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Decimal_Tab");
            byte retValue = rs.getByte(1);
            byte maxByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Decimal Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte23() throws EETest.Fault {
        String str = null;
        BigDecimal bigDecimalVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String Min_Val_Query = this.sqlp.getProperty("Decimal_Query_Min", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Decimal_Tab_Min_Update", null);
            bigDecimalVal = new BigDecimal(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setBigDecimal(1, bigDecimalVal);
            this.pstmt.executeUpdate();
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Decimal_Tab");
            byte retValue = rs.getByte(1);
            byte minByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Decimal Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte24() throws EETest.Fault {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling  getByte on Decimal_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte25() throws EETest.Fault {
        String str = null;
        BigDecimal bigDecimalVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String Max_Val_Query = this.sqlp.getProperty("Numeric_Query_Max", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Numeric_Tab_Max_Update", null);
            bigDecimalVal = new BigDecimal(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setBigDecimal(1, bigDecimalVal);
            this.pstmt.executeUpdate();
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Numeric_Tab");
            byte retValue = rs.getByte(1);
            byte maxByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Numeric Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte26() throws EETest.Fault {
        String str = null;
        BigDecimal bigDecimalVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String Min_Val_Query = this.sqlp.getProperty("Numeric_Query_Min", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Numeric_Tab_Min_Update", null);
            bigDecimalVal = new BigDecimal(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setBigDecimal(1, bigDecimalVal);
            this.pstmt.executeUpdate();
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Numeric_Tab");
            byte retValue = rs.getByte(1);
            byte minByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Numeric Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte27() throws EETest.Fault {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling  getByte on Numeric_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte31() throws EETest.Fault {
        String str = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String Max_Val_Query = this.sqlp.getProperty("Char_Query_Name", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Char_Tab_Name_Update", null);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setString(1, str);
            this.pstmt.executeUpdate();
            byte maxByteVal = Byte.parseByte(str);
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Char_Tab");
            byte retValue = rs.getByte(1);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the maximum value from Char Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte32() throws EETest.Fault {
        String str = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String Min_Val_Query = this.sqlp.getProperty("Char_Query_Name", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Char_Tab_Name_Update", null);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setString(1, str);
            this.pstmt.executeUpdate();
            byte minByteVal = Byte.parseByte(str);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Char_Tab");
            byte retValue = rs.getByte(1);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the minimum value from Char Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte33() throws EETest.Fault {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling  getByte on Char_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte34() throws EETest.Fault {
        String str = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String Max_Val_Query = this.sqlp.getProperty("Varchar_Query_Name", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Varchar_Tab_Name_Update", null);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setString(1, str);
            this.pstmt.executeUpdate();
            byte maxByteVal = Byte.parseByte(str);
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Varchar_Tab");
            byte retValue = rs.getByte(1);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the maximum value from Varchar Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte35() throws EETest.Fault {
        String str = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String Min_Val_Query = this.sqlp.getProperty("Varchar_Query_Name", "");
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Varchar_Tab_Name_Update", null);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setString(1, str);
            this.pstmt.executeUpdate();
            byte minByteVal = Byte.parseByte(str);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Varchar_Tab");
            byte retValue = rs.getByte(1);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the minimum value from Varchar Table ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte36() throws EETest.Fault {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling  getByte on Varchar_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

