/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.numberformat;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.AccessorCustomizedDoubleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.FieldCustomizedDoubleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.TypeCustomizedDoubleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.TypeCustomizedFieldOverriddenDoubleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.customized.PackageCustomizedDoubleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.customized.PackageCustomizedTypeOverriddenDoubleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.numberformat.model.customized.PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.util.Properties;

public class NumberFormatCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private static final String FRENCH_NUMBER = "\"123\\u00a0456,789\"";
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        NumberFormatCustomizationTest t = new NumberFormatCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testNumberFormatPackage() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123.456,8\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on package.");
        }
        PackageCustomizedDoubleContainer unmarshalledObject = (PackageCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123.456,789\" }", PackageCustomizedDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on package.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNumberFormatType() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new TypeCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123,456.79\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on type.");
        }
        TypeCustomizedDoubleContainer unmarshalledObject = (TypeCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123,456.789\" }", TypeCustomizedDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNumberFormatField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new FieldCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123\\u00a0456,789\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on field.");
        }
        FieldCustomizedDoubleContainer unmarshalledObject = (FieldCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123\\u00a0456,789\" }", FieldCustomizedDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on field.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNumberFormatAccessors() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new AccessorCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123,456.79\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on getter.");
        }
        AccessorCustomizedDoubleContainer unmarshalledObject = (AccessorCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123\\u00a0456,789\" }", AccessorCustomizedDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on setter.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNumberFormatPackageTypeOverride() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedTypeOverriddenDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123,456.79\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly override number format customization using JsonbNumberFormat annotation on package during marshalling using JsonbNumberFormat annotation on type.");
        }
        PackageCustomizedTypeOverriddenDoubleContainer unmarshalledObject = (PackageCustomizedTypeOverriddenDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123,456.789\" }", PackageCustomizedTypeOverriddenDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly override number format customization using JsonbNumberFormat annotation on package during unmarshalling using JsonbNumberFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNumberFormatTypeFieldOverride() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new TypeCustomizedFieldOverriddenDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123,456.8\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on type.");
        }
        TypeCustomizedFieldOverriddenDoubleContainer unmarshalledObject = (TypeCustomizedFieldOverriddenDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123,456.789\" }", TypeCustomizedFieldOverriddenDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNumberFormatPackageTypeOverrideFieldOverride() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123.456,789\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly override number format customization using JsonbNumberFormat annotation on package during marshalling using JsonbNumberFormat annotation on type.");
        }
        PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer unmarshalledObject = (PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123.456,789\" }", PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer.class);
        if (unmarshalledObject.getInstance() != 123456.789) {
            throw new EETest.Fault("Failed to correctly override number format customization using JsonbNumberFormat annotation on package during unmarshalling using JsonbNumberFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }
}

