/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.session.stateless.ejblink.single;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.ejb.ee.deploy.session.stateless.ejblink.single.TestBean;
import com.sun.ts.tests.ejb.ee.deploy.session.stateless.ejblink.single.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private TestBeanHome home = null;
    private TestBean bean = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logTrace("Client: Getting TS Naming Context...");
            this.nctx = new TSNamingContext();
            this.logMsg("Client: Initializing DB table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logTrace("Client: Looking up the Home...");
            this.home = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            this.logTrace("Client: Looked up Home!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Client: Setup failed:", e);
        }
    }

    public void testStatelessInternal() throws EETest.Fault {
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking Stateless internal references...");
            boolean pass = this.bean.testStatelessInternal(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("Stateless internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("Stateless internal EJB ref test failed!" + e, e);
        }
    }

    public void testStatelessExternal() throws EETest.Fault {
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking Stateless external references...");
            boolean pass = this.bean.testStatelessExternal(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("Stateless internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("Stateless internal EJB ref test failed!" + e, e);
        }
    }

    public void testStatefulInternal() throws EETest.Fault {
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking Stateful internal references...");
            boolean pass = this.bean.testStatefulInternal(this.props);
            this.bean.cleanUpBean();
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("Stateful internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("Stateful internal EJB ref test failed!" + e, e);
        }
    }

    public void testStatefulExternal() throws EETest.Fault {
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking Stateful external references...");
            boolean pass = this.bean.testStatefulExternal(this.props);
            this.bean.cleanUpBean();
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("Stateful external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("Stateful external EJB ref test failed!" + e, e);
        }
    }

    public void testBMPInternal() throws EETest.Fault {
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking BMP internal references...");
            boolean pass = this.bean.testBMPInternal(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("BMP internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("BMP internal EJB ref test failed!" + e, e);
        }
    }

    public void testBMPExternal() throws EETest.Fault {
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking BMP external references...");
            boolean pass = this.bean.testBMPExternal(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("BMP external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("BMP external EJB ref test failed!" + e, e);
        }
    }

    public void testCMP11Internal() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking CMP11 internal references...");
            pass = this.bean.testCMP11Internal(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("CMP11 internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("CMP11 internal EJB ref test failed!" + e, e);
        }
    }

    public void testCMP11External() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking CMP11 external references...");
            pass = this.bean.testCMP11External(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("CMP11 external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("CMP11 external EJB ref test failed!" + e, e);
        }
    }

    public void testCMP20Internal() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking CMP 2.0 internal references...");
            pass = this.bean.testCMP20Internal(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("CMP2.0 internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("CMP2.0 internal EJB ref test failed!" + e, e);
        }
    }

    public void testCMP20External() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logTrace("Client: Creating TestBean...");
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            this.logTrace("Client: Checking CMP 2.0 external references...");
            pass = this.bean.testCMP20External(this.props);
            this.bean.remove();
            if (!pass) {
                throw new EETest.Fault("CMP2.0 external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: ", e);
            throw new EETest.Fault("CMP2.0 external EJB ref test failed!" + e, e);
        }
    }

    public void cleanup() {
        this.logTrace("Client: Cleanup()");
    }
}

