/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.relationship.unimanyxone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.relationship.unimanyxone.UniMX1Person;
import com.sun.ts.tests.jpa.core.relationship.unimanyxone.UniMX1Project;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uniMX1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin uniMX1Test1");
        boolean pass = false;
        try {
            UniMX1Project newProject2;
            UniMX1Person newPerson2;
            UniMX1Project newProject;
            this.getEntityTransaction().begin();
            UniMX1Project project1 = new UniMX1Project(1L, "JavaEE", Float.valueOf(500.0f));
            UniMX1Person person1 = new UniMX1Person(1L, "Duke");
            UniMX1Person person2 = new UniMX1Person(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            person1.setProject(project1);
            person2.setProject(project1);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            TestUtil.logTrace((String)"persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            UniMX1Person newPerson = (UniMX1Person)this.getEntityManager().find(UniMX1Person.class, (Object)1L);
            if (newPerson != null && (newProject = newPerson.getProject()).getName().equals("JavaEE")) {
                pass1 = true;
            }
            if ((newPerson2 = (UniMX1Person)this.getEntityManager().find(UniMX1Person.class, (Object)2L)) != null && (newProject2 = newPerson2.getProject()).getName().equals("JavaEE")) {
                pass2 = true;
            }
            if (pass1 && pass2) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("uniMX1Test1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMX1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMX1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

