/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonvaluetests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonvaluetests.Structure;
import com.sun.ts.tests.jsonp.api.jsonvaluetests.Value;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonValueTypesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Testing getValueType for JsonValue.FALSE value");
            JsonValue.ValueType valueType = JsonValue.FALSE.getValueType();
            if (valueType != JsonValue.ValueType.FALSE) {
                this.logErr("Expected JSON FALSE value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON FALSE value");
            }
            this.logMsg("Testing getValueType for JsonValue.TRUE value");
            valueType = JsonValue.TRUE.getValueType();
            if (valueType != JsonValue.ValueType.TRUE) {
                this.logErr("Expected JSON TRUE value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON TRUE value");
            }
            this.logMsg("Testing getValueType for JsonValue.NULL value");
            valueType = JsonValue.NULL.getValueType();
            if (valueType != JsonValue.ValueType.NULL) {
                this.logErr("Expected JSON NULL value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON NULL value");
            }
            this.logMsg("Testing getValueType for JsonValue.String value");
            valueType = JSONP_Util.createJsonString("string").getValueType();
            if (valueType != JsonValue.ValueType.STRING) {
                this.logErr("Expected JSON STRING value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON STRING value");
            }
            this.logMsg("Testing getValueType for JsonValue.Number value");
            valueType = JSONP_Util.createJsonNumber(Integer.MAX_VALUE).getValueType();
            if (valueType != JsonValue.ValueType.NUMBER) {
                this.logErr("Expected JSON NUMBER value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON NUMBER value");
            }
            this.logMsg("Testing getValueType for JsonValue.Array value");
            valueType = JSONP_Util.createJsonArrayFromString("[]").getValueType();
            if (valueType != JsonValue.ValueType.ARRAY) {
                this.logErr("Expected JSON ARRAY value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON ARRAY value");
            }
            this.logMsg("Testing getValueType for JsonValue.Object value");
            valueType = JSONP_Util.createJsonObjectFromString("{}").getValueType();
            if (valueType != JsonValue.ValueType.OBJECT) {
                this.logErr("Expected JSON OBJECT value type but got instead " + valueType);
                pass = false;
            } else {
                this.logMsg("Got expected value type for JSON OBJECT value");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonValueTypesTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonValueTypesTest Failed");
        }
    }

    public void jsonValueOfTest() throws EETest.Fault {
        String[] valueTypeStrings;
        boolean pass = true;
        for (String valueTypeString : valueTypeStrings = new String[]{"ARRAY", "FALSE", "NULL", "NUMBER", "OBJECT", "STRING", "TRUE"}) {
            try {
                this.logMsg("Testing enum value for string constant name " + valueTypeString);
                JsonValue.ValueType valueType = JsonValue.ValueType.valueOf((String)valueTypeString);
                this.logMsg("Got enum type " + valueType + " for enum string constant named " + valueTypeString);
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: " + e);
                pass = false;
            }
        }
        this.logMsg("Testing negative test case for NullPointerException");
        try {
            JsonValue.ValueType.valueOf(null);
            this.logErr("did not get expected NullPointerException");
            pass = false;
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            this.logErr("Got unexpected exception " + e);
            pass = false;
        }
        this.logMsg("Testing negative test case for IllegalArgumentException");
        try {
            JsonValue.ValueType.valueOf((String)"INVALID");
            this.logErr("did not get expected IllegalArgumentException");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            this.logMsg("Got expected IllegalArgumentException");
        }
        catch (Exception e) {
            this.logErr("Got unexpected exception " + e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("jsonValueOfTest Failed");
        }
    }

    public void jsonValuesTest() throws EETest.Fault {
        JsonValue.ValueType[] values;
        boolean pass = true;
        this.logMsg("Testing API method JsonValue.ValueType.values() to return array of enums.");
        for (JsonValue.ValueType valueType : values = JsonValue.ValueType.values()) {
            String valueString = JSONP_Util.getValueTypeString(valueType);
            if (valueString == null) {
                this.logErr("Got no value for enum " + valueType);
                pass = false;
                continue;
            }
            this.logMsg("Got " + valueString + " for enum " + valueType);
        }
        if (!pass) {
            throw new EETest.Fault("jsonValuesTest Failed");
        }
    }

    public void jsonValueToStringTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Testing JsonValue.toString() for JsonValue.FALSE value");
            String stringValue = JsonValue.FALSE.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("false")) {
                this.logErr("Expected false");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
            this.logMsg("Testing JsonValue.toString() for JsonValue.TRUE value");
            stringValue = JsonValue.TRUE.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("true")) {
                this.logErr("Expected true");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
            this.logMsg("Testing JsonValue.toString() for JsonValue.NULL value");
            stringValue = JsonValue.NULL.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("null")) {
                this.logErr("Expected null");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
            this.logMsg("Testing JsonValue.toString() for JsonString value");
            JsonString jsonValue = JSONP_Util.createJsonString("string");
            stringValue = jsonValue.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("\"string\"")) {
                this.logErr("Expected \"string\"");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
            this.logMsg("Testing JsonValue.toString() for JsonNumber value");
            jsonValue = JSONP_Util.createJsonNumber(10);
            stringValue = jsonValue.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("10")) {
                this.logErr("Expected 10");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
            this.logMsg("Testing JsonValue.toString() for JsonArray value");
            jsonValue = JSONP_Util.createJsonArrayFromString("[]");
            stringValue = jsonValue.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("[]")) {
                this.logErr("Expected []");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
            this.logMsg("Testing JsonValue.toString() for JsonObject value");
            jsonValue = JSONP_Util.createJsonObjectFromString("{}");
            stringValue = jsonValue.toString();
            this.logMsg("stringValue=" + stringValue);
            if (!stringValue.equals("{}")) {
                this.logErr("Expected {}");
                pass = false;
            } else {
                this.logMsg("Got " + stringValue);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonValueToStringTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonValueToStringTest Failed");
        }
    }

    public void jsonValue11Test() throws EETest.Fault {
        Value valueTest = new Value();
        TestResult result = valueTest.test();
        result.eval();
    }

    public void jsonStructure11Test() throws EETest.Fault {
        Structure structTest = new Structure();
        TestResult result = structTest.test();
        result.eval();
    }
}

