/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateless.statetest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.statetest.Counter;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.statetest.CounterHome;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.statetest.InvalidTransactionException;
import java.util.Properties;

public class Client
extends EETest {
    private static final int SLEEPTIME = 5000;
    private static final String testName = "StateTest";
    private static final String testLookup = "java:comp/env/ejb/Counter";
    private static Properties props = null;
    private static TSNamingContext nctx = null;
    private static CounterHome counterHome = null;
    private static final int NTHREADS = 2;
    private static Object lock = new Object();
    private static Object startLock = new Object();
    private static int threadsDone = 0;
    private static int errors = 0;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        props = p;
        try {
            this.logMsg("Obtain naming context");
            nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/Counter");
            counterHome = (CounterHome)nctx.lookup(testLookup, CounterHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1() throws EETest.Fault {
        try {
            Thread[] threads = new Thread[1];
            threadsDone = 0;
            errors = 0;
            this.logMsg("Creating 1 threads ...");
            for (int i = 0; i < 1; ++i) {
                threads[i] = new Thread((Runnable)new CounterThread(i), "CounterThread-" + i);
                threads[i].start();
            }
            this.logMsg("wait for thread creation ...");
            Object object = lock;
            synchronized (object) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logMsg("notify all threads to start");
            object = startLock;
            synchronized (object) {
                threadsDone = 0;
                startLock.notifyAll();
            }
            this.logMsg("wait for all threads to finish");
            object = lock;
            synchronized (object) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
            }
            if (errors > 0) {
                this.logMsg("The number of errors were: " + errors);
                throw new EETest.Fault("test1 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2() throws EETest.Fault {
        try {
            Thread[] threads = new Thread[2];
            threadsDone = 0;
            errors = 0;
            this.logMsg("Creating 2 threads ...");
            for (int i = 0; i < 2; ++i) {
                threads[i] = new Thread((Runnable)new CounterThread(i), "CounterThread-" + i);
                threads[i].start();
            }
            this.logMsg("wait for thread creation ...");
            Object object = lock;
            synchronized (object) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logMsg("notify all threads to start");
            object = startLock;
            synchronized (object) {
                threadsDone = 0;
                startLock.notifyAll();
            }
            this.logMsg("wait for all threads to finish");
            object = lock;
            synchronized (object) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
            }
            if (errors > 0) {
                this.logMsg("The number of errors were: " + errors);
                throw new EETest.Fault("test1 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    class CounterThread
    implements Runnable {
        private int threadNum;
        private Counter counter;
        private int value = 0;

        public CounterThread() {
        }

        public CounterThread(int n) {
            this.threadNum = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = lock;
            synchronized (object) {
                ++threadsDone;
                lock.notifyAll();
            }
            object = startLock;
            synchronized (object) {
                try {
                    startLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean pass = this.runTest();
            Object object2 = lock;
            synchronized (object2) {
                if (!pass) {
                    ++errors;
                }
                ++threadsDone;
                lock.notifyAll();
            }
        }

        public boolean runTest() {
            boolean pass = true;
            try {
                Client.this.logMsg("Client EJB instance for thread" + this.threadNum);
                this.counter = counterHome.create();
                Client.this.logMsg("initialize remote logging");
                this.counter.initLogging(props);
                this.value = this.counter.value(this.value);
                Client.this.logMsg("Counter.value(): " + this.value);
                if (this.value != 0) {
                    Client.this.logErr("value: expected 0, received " + this.value);
                    pass = false;
                } else {
                    Client.this.logMsg("value: expected 0, received " + this.value);
                }
                Client.this.logMsg("increment counter");
                this.value = this.counter.increment(this.value);
                Client.this.logMsg("Counter.value(): " + this.value);
                if (this.value != 1) {
                    Client.this.logErr("value: expected 1, received " + this.value);
                    pass = false;
                } else {
                    Client.this.logMsg("value: expected 1, received " + this.value);
                }
                Client.this.logMsg("decrement counter");
                this.value = this.counter.decrement(this.value);
                Client.this.logMsg("Counter.value(): " + this.value);
                if (this.value != 0) {
                    Client.this.logErr("value: expected 0, received " + this.value);
                    pass = false;
                } else {
                    Client.this.logMsg("value: expected 0, received " + this.value);
                }
                try {
                    Client.this.logMsg("decrement counter again - InvalidTransactionException");
                    this.value = this.counter.decrement(this.value);
                    Client.this.logErr("no exception occurred - unexpected");
                    pass = false;
                }
                catch (InvalidTransactionException e) {
                    Client.this.logMsg("InvalidTransactionException received as expected");
                }
                catch (Exception e) {
                    Client.this.logErr("Exception: " + e, e);
                    pass = false;
                }
            }
            catch (Exception e) {
                Client.this.logErr("Exception: " + e, e);
                pass = false;
            }
            return pass;
        }
    }
}

