/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.joincolumn;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.joincolumn.Course;
import com.sun.ts.tests.jpa.core.override.joincolumn.Cubicle;
import com.sun.ts.tests.jpa.core.override.joincolumn.Customer1;
import com.sun.ts.tests.jpa.core.override.joincolumn.Hardware;
import com.sun.ts.tests.jpa.core.override.joincolumn.RetailOrder1;
import com.sun.ts.tests.jpa.core.override.joincolumn.Student;
import com.sun.ts.tests.jpa.core.override.joincolumn.TheatreCompany1;
import com.sun.ts.tests.jpa.core.override.joincolumn.TheatreLocation1;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long COMPANY_ID = 676L;
    private static final String COMPANY_NAME = "Regal";
    private static final long LOCATION_ID = 42L;
    private static final String LOCATION_CODE = "KXTN";
    private static final long CITY_ID = 47L;
    private static final String CITY_CODE = "ICIO";
    private static final int STUDENT1_ID = 420;
    private static final String STUDENT1_NAME = "Charsoubees";
    private static final int STUDENT2_ID = 421;
    private static final String STUDENT2_NAME = "CharsouIkkis";
    private static final int STUDENT3_ID = 422;
    private static final String STUDENT3_NAME = "CharsouBais";
    private static final int STUDENT4_ID = 423;
    private static final String STUDENT4_NAME = "CharsouTeis";
    private static final int STUDENT5_ID = 424;
    private static final String STUDENT5_NAME = "CharsouChoubees";
    private static final int MATH_ID = 104;
    private static final String MATH_COURSE = "Math";
    private static final int CHEM_ID = 204;
    private static final String CHEM_COURSE = "Chemistry";
    private static final int Hardware1_ID = 9030;
    private static final String Hardware1_CODE = "Connoi-LapTop43";
    private static final int Hardware2_ID = 9031;
    private static final String Hardware2_CODE = "Connoi-DeskTop02";
    private static final int CUBICLE1_ID = 199;
    private static final String CUBICLE1_NAME = "Z678";
    private static final long ORDER1_ID = 786L;
    private static final long ORDER2_ID = 787L;
    private static final long ORDER3_ID = 788L;
    private static final long ORDER4_ID = 789L;
    private static final double COST1 = 53.0;
    private static final double COST2 = 540.0;
    private static final double COST3 = 155.0;
    private static final double COST4 = 256.0;
    private static final long CUST1_ID = 2L;
    private static final long CUST2_ID = 4L;
    private static final String CUST1_NAME = "Ross";
    private static final String CUST2_NAME = "Joey";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception:test failed ", (Throwable)e);
        }
    }

    public void testNoJoinColumnAnnotation() throws EETest.Fault {
        block6: {
            TheatreCompany1 regal = this.createTheatreCompany(676L, COMPANY_NAME);
            TheatreLocation1 knoxville = this.createTheatreLocation(42L, LOCATION_CODE);
            TheatreLocation1 iowacity = this.createTheatreLocation(47L, CITY_CODE);
            knoxville.setCompany(regal);
            iowacity.setCompany(regal);
            HashSet<TheatreLocation1> regalLocations = new HashSet<TheatreLocation1>();
            regalLocations.add(knoxville);
            regalLocations.add(iowacity);
            regal.setLocations(regalLocations);
            try {
                this.getEntityTransaction().begin();
                this.getEntityManager().persist((Object)regal);
                this.getEntityManager().flush();
                this.getEntityManager().persist((Object)knoxville);
                this.getEntityManager().flush();
                this.getEntityManager().persist((Object)iowacity);
                this.getEntityManager().flush();
                List result = this.getEntityManager().createQuery("SELECT l FROM TheatreLocation1 l").getResultList();
                if (result.size() == 2) {
                    TestUtil.logTrace((String)"testNoJoinColumnAnnotation passed");
                    break block6;
                }
                throw new EETest.Fault("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testNoJoinColumnAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)regal);
                this.getEntityManager().remove((Object)knoxville);
                this.getEntityManager().remove((Object)iowacity);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testNoJoinTableAnnotation() throws EETest.Fault {
        Course mathCourse = this.createCourse(104, MATH_COURSE);
        Course chemCourse = this.createCourse(204, CHEM_COURSE);
        Student student1 = this.createStudent(420, STUDENT1_NAME);
        student1.addCourse(mathCourse);
        Student student2 = this.createStudent(421, STUDENT2_NAME);
        student2.addCourse(mathCourse);
        Student student3 = this.createStudent(422, STUDENT3_NAME);
        student3.addCourse(chemCourse);
        Student student4 = this.createStudent(423, STUDENT4_NAME);
        student4.addCourse(mathCourse);
        Student student5 = this.createStudent(424, STUDENT5_NAME);
        student5.addCourse(chemCourse);
        HashSet<Student> mathStudents = new HashSet<Student>();
        mathStudents.add(student1);
        mathStudents.add(student2);
        mathStudents.add(student4);
        HashSet<Student> chemStudents = new HashSet<Student>();
        chemStudents.add(student3);
        chemStudents.add(student5);
        mathCourse.setStudents(mathStudents);
        chemCourse.setStudents(chemStudents);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)mathCourse);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)chemCourse);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"testNoJoinTableAnnotation passed");
        }
        catch (Exception e) {
            throw new EETest.Fault(" Test failed -" + e);
        }
        finally {
            this.getEntityManager().remove((Object)mathCourse);
            this.getEntityManager().remove((Object)chemCourse);
            this.getEntityTransaction().commit();
        }
    }

    public void testOverrideJoinColumns() throws EETest.Fault {
        Hardware equipment1 = new Hardware();
        equipment1.setId(Integer.valueOf(9030));
        equipment1.setSalesCode(Hardware1_CODE);
        Hardware equipment2 = new Hardware();
        equipment2.setId(Integer.valueOf(9031));
        equipment2.setSalesCode(Hardware2_CODE);
        Cubicle cubicle = new Cubicle();
        cubicle.setId(Integer.valueOf(199));
        cubicle.setLocation(CUBICLE1_NAME);
        equipment1.setCubicle(cubicle);
        equipment2.setCubicle(cubicle);
        cubicle.addEquipment(equipment1);
        cubicle.addEquipment(equipment2);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)cubicle);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)equipment1);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)equipment2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"Test Passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("test failed" + e);
        }
        finally {
            this.getEntityManager().remove((Object)cubicle);
            this.getEntityManager().remove((Object)equipment1);
            this.getEntityManager().remove((Object)equipment2);
            this.getEntityTransaction().commit();
        }
    }

    public void testOverrideJoinTable() throws EETest.Fault {
        Customer1 customer1 = this.createCustomer(2L, CUST1_NAME);
        Customer1 customer2 = this.createCustomer(4L, CUST2_NAME);
        RetailOrder1 order1 = this.createOrder(786L, 53.0);
        RetailOrder1 order2 = this.createOrder(787L, 540.0);
        RetailOrder1 order3 = this.createOrder(788L, 155.0);
        RetailOrder1 order4 = this.createOrder(789L, 256.0);
        customer1.addOrder(order1);
        customer1.addOrder(order2);
        customer2.addOrder(order3);
        customer2.addOrder(order4);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)order1);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)order2);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)order3);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)order4);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)customer1);
            this.getEntityManager().flush();
            this.getEntityManager().persist((Object)customer2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"Test Passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test failed" + e);
        }
        finally {
            this.getEntityManager().remove((Object)order1);
            this.getEntityManager().remove((Object)order2);
            this.getEntityManager().remove((Object)order3);
            this.getEntityManager().remove((Object)order4);
            this.getEntityManager().remove((Object)customer1);
            this.getEntityManager().remove((Object)customer2);
            this.getEntityTransaction().commit();
        }
    }

    private TheatreLocation1 createTheatreLocation(long id, String code) {
        TheatreLocation1 loc = new TheatreLocation1();
        loc.setId(Long.valueOf(id));
        loc.setCode(code);
        return loc;
    }

    private TheatreCompany1 createTheatreCompany(long id, String name) {
        TheatreCompany1 company = new TheatreCompany1();
        company.setId(Long.valueOf(id));
        company.setName(name);
        return company;
    }

    private Student createStudent(int id, String name) {
        Student student = new Student();
        student.setId(Integer.valueOf(id));
        student.setName(name);
        return student;
    }

    private Course createCourse(int id, String courseName) {
        Course course = new Course();
        course.setId(Integer.valueOf(id));
        course.setName(courseName);
        return course;
    }

    private RetailOrder1 createOrder(long id, double cost) {
        RetailOrder1 order = new RetailOrder1();
        order.setId(Long.valueOf(id));
        order.setCost(cost);
        return order;
    }

    private Customer1 createCustomer(long id, String name) {
        Customer1 customer = new Customer1();
        customer.setId(Long.valueOf(id));
        customer.setName(name);
        return customer;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COURSE_2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUBICLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUSTOMER1").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM HARDWARE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM RETAILORDER1").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM STUDENT_2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM STUDENT_2_COURSE_2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM THEATRECOMPANY1").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM THEATRELOCATION1").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

