/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.StaticNodeList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.css.sac.CSSException;

@JsxClass(domClass=DomDocumentFragment.class)
public class DocumentFragment
extends Node {
    @Override
    public Object getXml() {
        Node node = this.getFirstChild();
        if (node != null) {
            return node.getXml();
        }
        return "";
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object createAttribute(String attributeName) {
        return this.getDocument().createAttribute(attributeName);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public Object createElement(String tagName) {
        return this.getDocument().createElement(tagName);
    }

    protected HTMLDocument getDocument() {
        return (HTMLDocument)((DomNode)this.getDomNodeOrDie()).getPage().getScriptObject();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object createComment(String comment) {
        return this.getDocument().createComment(comment);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object createDocumentFragment() {
        return this.getDocument().createDocumentFragment();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object createTextNode(String newData) {
        return this.getDocument().createTextNode(newData);
    }

    @JsxFunction
    public StaticNodeList querySelectorAll(String selectors) {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (DomNode domNode : ((DomNode)this.getDomNodeOrDie()).querySelectorAll(selectors)) {
                nodes.add((Node)domNode.getScriptObject());
            }
            return new StaticNodeList(nodes, this);
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public Node querySelector(String selectors) {
        try {
            DomNode node = ((DomNode)this.getDomNodeOrDie()).querySelector(selectors);
            if (node != null) {
                return (Node)node.getScriptObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }
}

