/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class CSSRuleList
extends SimpleScriptable {
    private final CSSStyleSheet stylesheet_;
    private final org.w3c.dom.css.CSSRuleList rules_;

    @Deprecated
    public CSSRuleList() {
        this.stylesheet_ = null;
        this.rules_ = null;
    }

    public CSSRuleList(CSSStyleSheet stylesheet) {
        this.stylesheet_ = stylesheet;
        this.rules_ = stylesheet.getWrappedSheet().getCssRules();
        this.setParentScope(stylesheet.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxGetter
    public int getLength() {
        if (this.rules_ != null) {
            return this.rules_.getLength();
        }
        return 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public Object item(int index) {
        return null;
    }

    public Object[] getIds() {
        ArrayList<String> idList = new ArrayList<String>();
        int length = this.getLength();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CSSRULELIST_DONT_ENUM_ITEM)) {
            idList.add("length");
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            idList.add("item");
        }
        return idList.toArray();
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getLength();
    }

    public boolean has(String name, Scriptable start) {
        if ("length".equals(name) || "item".equals(name)) {
            return true;
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || this.getLength() <= index) {
            return NOT_FOUND;
        }
        return CSSRule.create(this.stylesheet_, this.rules_.item(index));
    }
}

