/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlWordBreak;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlWordBreak.class, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
public class HTMLTextElement
extends HTMLElement {
    private boolean endTagForbidden_;

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (domNode instanceof HtmlWordBreak) {
            this.endTagForbidden_ = true;
        }
    }

    @Override
    @JsxGetter
    public String getText() {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return "";
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        DomNode firstChild = htmlElement.getFirstChild();
        if (firstChild == null) {
            firstChild = new DomText(htmlElement.getPage(), text);
            htmlElement.appendChild(firstChild);
        } else {
            firstChild.setNodeValue(text);
        }
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }
}

