/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonnumbertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.JsonNumber;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonNumberEqualsTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonNumber 1 for testing");
            JsonNumber number1 = JSONP_Util.createJsonNumber(10);
            this.logMsg("number1=" + JSONP_Util.toStringJsonNumber(number1));
            this.logMsg("Create sample JsonNumber 2 for testing");
            JsonNumber number2 = JSONP_Util.createJsonNumber(10);
            this.logMsg("number2=" + JSONP_Util.toStringJsonNumber(number2));
            this.logMsg("Call JsonNumber.equals() to compare 2 equal JsonNumbers and expect true");
            if (number1.equals((Object)number2)) {
                this.logMsg("JsonNumbers are equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonNumbers are not equal - unexpected.");
            }
            this.logMsg("Create sample JsonNumber 1 for testing");
            number1 = JSONP_Util.createJsonNumber(10);
            this.logMsg("number1=" + JSONP_Util.toStringJsonNumber(number1));
            this.logMsg("Create sample JsonNumber 2 for testing");
            number2 = JSONP_Util.createJsonNumber(10.25);
            this.logMsg("number2=" + JSONP_Util.toStringJsonNumber(number2));
            this.logMsg("Call JsonNumber.equals() to compare 2 equal JsonNumbers and expect false");
            if (!number1.equals((Object)number2)) {
                this.logMsg("JsonNumbers are not equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonNumbers are equal - unexpected.");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonNumberEqualsTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonNumberEqualsTest Failed");
        }
    }

    public void jsonNumberHashCodeTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonNumber 1 for testing");
            JsonNumber number1 = JSONP_Util.createJsonNumber(10);
            this.logMsg("number1=" + JSONP_Util.toStringJsonNumber(number1));
            this.logMsg("number1.hashCode()=" + number1.hashCode());
            this.logMsg("Create sample JsonNumber 2 for testing");
            JsonNumber number2 = JSONP_Util.createJsonNumber(10);
            this.logMsg("number2=" + JSONP_Util.toStringJsonNumber(number2));
            this.logMsg("number2.hashCode()=" + number2.hashCode());
            this.logMsg("Call JsonNumber.hashCode() to compare 2 equal JsonNumbers and expect true");
            if (number1.hashCode() == number2.hashCode()) {
                this.logMsg("JsonNumbers hashCode are equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonNumbers hashCode are not equal - unexpected.");
            }
            this.logMsg("Create sample JsonNumber 1 for testing");
            number1 = JSONP_Util.createJsonNumber(10);
            this.logMsg("number1=" + JSONP_Util.toStringJsonNumber(number1));
            this.logMsg("number1.hashCode()=" + number1.hashCode());
            this.logMsg("Create sample JsonNumber 2 for testing");
            number2 = JSONP_Util.createJsonNumber(10.25);
            this.logMsg("number2=" + JSONP_Util.toStringJsonNumber(number2));
            this.logMsg("number2.hashCode()=" + number2.hashCode());
            this.logMsg("Call JsonNumber.hashCode() to compare 2 equal JsonNumbers and expect false");
            if (number1.hashCode() != number2.hashCode()) {
                this.logMsg("JsonNumbers hashCode are not equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonNumbers hashCode are equal - unexpected.");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonNumberHashCodeTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonNumberHashCodeTest Failed");
        }
    }

    public void jsonNumberIsIntegralTest() throws EETest.Fault {
        boolean pass = true;
        Object jsonNumber = null;
        try {
            JsonNumber number1 = JSONP_Util.createJsonNumber(123);
            if (!JSONP_Util.assertEqualsJsonNumberType(number1.isIntegral(), true)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals(123, number1.intValue())) {
                pass = false;
            }
            JsonNumber number2 = JSONP_Util.createJsonNumber(12345.45);
            if (!JSONP_Util.assertEqualsJsonNumberType(number2.isIntegral(), false)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals(12345.45, number2.doubleValue())) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonNumberIsIntegralTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonNumberIsIntegralTest Failed");
        }
    }
}

