/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.null_values;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.props = p;
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void nullTest1() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers who have a null relationship");
            c = this.customerHome.findCustomersByQuery14();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers who have a null relationship");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers have a null relationship");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest1 failed");
        }
    }

    public void nullTest2() throws EETest.Fault {
        boolean pass = true;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers who do not have null relationship");
            c = this.customerHome.findCustomersByQuery15();
            if (c.size() != 0) {
                TestUtil.logErr((String)("findCustomersByQuery15 returned " + c.size() + " references, expected 0 references"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers without null relationships");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest2 failed");
        }
    }

    public void nullTest3() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Determine if customer has a NULL relationship");
            c = this.customerHome.findCustomersByQuery22("Shelly D. Mcgowan");
            expectedPKs = new String[]{"3"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customer Shelly D. Mcgowan");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Shelly D. Mcgowan");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest3 failed");
        }
    }

    public void nullTest4() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Determine if customer has a NULL relationship");
            c = this.customerHome.findCustomersByQuery23("Arthur D. Frechette");
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customer OR customers have null relationships");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Arthur D. Frechette OR customers have null relationships");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest4 failed");
        }
    }

    public void nullTest5() throws EETest.Fault {
        boolean pass = true;
        Object expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Determine if customers have a NULL relationship");
            c = this.customerHome.findCustomersByQuery24();
            if (c.size() != 0) {
                TestUtil.logErr((String)("findCustomersByQuery24 returned " + c.size() + " references, expected 0 references"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers have null relationships");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest5 failed");
        }
    }

    public void nullTest6() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Determine which customers have an area code beginning with 9");
            c = this.customerHome.findCustomersByQuery38("9%");
            expectedPKs = new String[]{"3", "12"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest6 failed");
        }
    }

    public void nullTest7() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        Collection c = null;
        String[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            TestUtil.logMsg((String)"Find all work zip codes via ejbSelectCustomersByWorkZipCodes");
            c = this.customerHome.selectCustomersByWorkZipCode();
            if (c.size() != 14) {
                TestUtil.logErr((String)("selectCustomersByWorkZipCode returned " + c.size() + " references, expected 14 references"));
                pass1 = false;
            } else if (pass1) {
                Iterator i = c.iterator();
                int numOfNull = 0;
                int foundZip = 0;
                block2: while (i.hasNext()) {
                    TestUtil.logTrace((String)"Check contents of collection for null");
                    Object o = i.next();
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    TestUtil.logTrace((String)"Check collection for expected zip codes");
                    for (int l = 0; l < 13; ++l) {
                        if (!expectedZips[l].equals(o)) continue;
                        ++foundZip;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundZip != 13) {
                    TestUtil.logErr((String)"selectCustomersByWorkZipCode did not return expected results");
                    pass2 = false;
                } else {
                    TestUtil.logMsg((String)"Successfully returned expected results");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest7 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("nullTest7 failed");
        }
    }

    public void nullTest8() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Find customer spouse");
            c = this.customerHome.findCustomerByQuery40();
            if (c != null) {
                TestUtil.logErr((String)("findCustomerByQuery40 returned " + c + " expected: null"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest8: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest8 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest8 failed");
        }
    }

    public void nullTest9() throws EETest.Fault {
        boolean pass = true;
        String s = null;
        try {
            TestUtil.logMsg((String)"Find home zip codes via ejbSelectCustomerByHomeAddress");
            s = this.customerHome.selectCustomerByHomeAddress();
            if (s != null) {
                TestUtil.logErr((String)("selectCustomerByHomeAddress returned " + s + " expected: null"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest9: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest9 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest9 failed");
        }
    }

    public void nullTest10() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Determine which customers have an null name");
            c = this.customerHome.findCustomersByQuery39();
            expectedPKs = new String[]{"12"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest10: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest10 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest10 failed");
        }
    }

    public void nullTest11() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders where related customer name is not null");
            o = this.orderHome.findOrdersByQuery20();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest11: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest11 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest11 failed");
        }
    }

    public void nullTest12() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Check results of AND operator: False AND False = False");
            p = this.productHome.findProductsByQuery7(100);
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest12: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest12 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest12 failed");
        }
    }

    public void nullTest13() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Provide a null value for a comparison operation and verify the results");
            p = this.productHome.findProductsByQuery8(null);
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest13: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest13 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest13 failed");
        }
    }

    public void nullTest14() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        long c1 = 0L;
        long c2 = 0L;
        long expectedResult1 = 13L;
        long expectedResult2 = 12L;
        try {
            TestUtil.logMsg((String)"Execute two queries composed differently and verify results");
            c1 = this.customerHome.selectAllHomeCities();
            c2 = this.customerHome.selectNotNullHomeCities();
            if (c1 != expectedResult1) {
                TestUtil.logErr((String)("ERROR: selectAllHomeCities returned:" + c1 + " expected: " + expectedResult1));
                pass1 = false;
            } else {
                TestUtil.logMsg((String)"PASS:  selectAllHomeCities returned expected results");
                pass1 = true;
            }
            if (c2 != expectedResult2) {
                TestUtil.logErr((String)("ERROR: selectNotNullHomeCities returned:" + c2 + " expected: " + expectedResult2));
                pass2 = false;
            } else {
                TestUtil.logMsg((String)"PASS:  selectNotNullHomeCities returned expected results");
                pass2 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest14: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest14 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("nullTest14 failed");
        }
    }

    public void nullTest15() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find customers whose id is greater than 1 and where the relationship is NOT EMPTY");
            c = this.customerHome.findCustomersByQuery43();
            expectedPKs = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected customers");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expected customers");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest15: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest15 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest15 failed");
        }
    }

    public void nullTest16() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedResult1 = new String[]{null};
        Object[] expectedResult2 = new String[]{null, null, null};
        Collection s = null;
        try {
            TestUtil.logMsg((String)"Execute query with input parameter and IS NULL");
            s = this.aliasHome.selectNullAlias(null);
            if (s.size() == 1) {
                TestUtil.logMsg((String)("Checking results for alias names with size of " + s.size()));
                Object[] result = s.toArray(new String[s.size()]);
                pass = Arrays.equals(expectedResult1, result);
                TestUtil.logMsg((String)("Received expected results with size :" + s.size()));
            } else if (s.size() == 3) {
                Object[] result = s.toArray(new String[s.size()]);
                pass = Arrays.equals(expectedResult2, result);
                TestUtil.logMsg((String)("Received expected results with size :" + s.size()));
            } else {
                TestUtil.logErr((String)"ERROR: Did not received expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest16: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest16 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest16 failed");
        }
    }

    public void nullTest17() throws EETest.Fault {
        boolean pass = false;
        String[] expectedPKs = null;
        String[] expectedPKs1 = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Execute query with input parameter and IS NOT NULL");
            a = this.aliasHome.findAliasesByQuery8("adf");
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29"};
            expectedPKs1 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29"};
            if (a.size() == 29) {
                TestUtil.logMsg((String)("Checking results for expectedPKs with size of " + a.size()));
                pass = Util.checkEJBs(a, 3, expectedPKs);
            } else if (a.size() == 27) {
                TestUtil.logMsg((String)("Checking results for expectedPK1s with size of " + a.size()));
                pass = Util.checkEJBs(a, 3, expectedPKs1);
            } else {
                TestUtil.logErr((String)"ERROR: Did not received expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest17 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest17 failed");
        }
    }

    public void nullTest18() throws EETest.Fault {
        boolean pass = false;
        Collection c = null;
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            TestUtil.logMsg((String)"Find work zip codes that are not null via ejbSelectCustomersByNotNullWorkZipCodes");
            c = this.customerHome.selectCustomersByNotNullWorkZipCode();
            Object[] result = c.toArray(new String[c.size()]);
            TestUtil.logMsg((String)"Compare results of work zip codes");
            pass = Arrays.equals(expectedZips, result);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest18: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest18 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest18 failed");
        }
    }

    public void nullTest19() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find all aliases where Customer name is not null");
            a = this.aliasHome.findAliasesByQuery10();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "17", "18", "19", "20", "21", "22", "23", "24", "26", "27", "28", "29", "30"};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest19: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest19 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest19 failed");
        }
    }

    public void nullTest20() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Check results of AND operator: False AND True = False");
            c = this.customerHome.findCustomersByQuery22("George W. Bush");
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest20: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest20 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest20 failed");
        }
    }

    public void nullTest21() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Check results of OR operator: False OR True = True");
            c = this.customerHome.findCustomersByQuery23("George W. Bush");
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest21: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest21 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest21 failed");
        }
    }

    public void nullTest22() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Check results of OR operator: False OR False = False");
            a = this.aliasHome.findAliasesByQuery9("99");
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest22: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest22 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest22 failed");
        }
    }

    public void nullTest23() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        Collection c = null;
        String[] expectedPKs = null;
        try {
            TestUtil.logMsg((String)"Find customers of spouses");
            c = this.customerHome.findCustomersByQuery41();
            expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (c.size() != 6) {
                TestUtil.logErr((String)("findCustomersByQuery41 returned " + c.size() + " references, expected 6 references"));
                pass1 = false;
            } else if (pass1) {
                Iterator i = c.iterator();
                int numOfNull = 0;
                int foundPK = 0;
                block2: while (i.hasNext()) {
                    TestUtil.logTrace((String)"Check contents of collection for null");
                    Object o = i.next();
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    TestUtil.logTrace((String)"Check collection for expected references");
                    Customer cRef = (Customer)PortableRemoteObject.narrow(o, Customer.class);
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedPKs[l].equals(cRef.getId())) continue;
                        ++foundPK;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundPK != 5) {
                    TestUtil.logErr((String)"findCustomersByQuery41 did not return expected results");
                    pass2 = false;
                } else {
                    TestUtil.logMsg((String)"Successfully returned expected results");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest23: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest23 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("nullTest23 failed");
        }
    }

    public void nullTest24() throws EETest.Fault {
        boolean pass = true;
        String s = null;
        try {
            TestUtil.logMsg((String)"Find spouse information via ejbSelectSpouseInfo");
            s = this.customerHome.getSpouseInfo();
            if (s != null) {
                TestUtil.logErr((String)("selectSpouseInfo " + s + " expected: null"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest24: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest24 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest24 failed");
        }
    }

    public void nullTest25() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Execute query with OR condition where first condition is TRUE");
            a = this.aliasHome.findAliasesByQuery11();
            expectedPKs = new String[30];
            for (int i = 0; i < 30; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest25: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest25 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest25 failed");
        }
    }

    public void nullTest26() throws EETest.Fault {
        boolean pass = true;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find all aliases who are not null AND are not equal");
            a = this.aliasHome.findAliasesByQuery12();
            if (a.size() != 0) {
                TestUtil.logErr((String)("findAliasesByQuery12 returned " + a.size() + " references, expected 0 references"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest26: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest26 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest26 failed");
        }
    }

    public void nullTest27() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        Collection o = null;
        Double[] expectedBalances = new Double[]{new Double(500.0), new Double(750.0), new Double(1000.0), new Double(1400.0), new Double(1500.0), new Double(2000.0), new Double(2500.0), new Double(4400.0), new Double(5000.0), new Double(5500.0), new Double(7000.0), new Double(8000.0), new Double(13000.0), new Double(15000.0), new Double(23000.0)};
        try {
            TestUtil.logMsg((String)"Find all credit card balances via ejbSelectAllCreditCardBalances");
            o = this.orderHome.selectAllCreditCardBalances();
            if (o.size() != 15) {
                TestUtil.logErr((String)("selectAllCreditCardBalances returned " + o.size() + " references, expected 15 references"));
                pass1 = false;
            } else if (pass1) {
                Iterator i = o.iterator();
                int numOfNull = 0;
                int foundBalance = 0;
                block2: while (i.hasNext()) {
                    TestUtil.logTrace((String)"Check contents of collection for null");
                    Object b = i.next();
                    if (b == null) {
                        ++numOfNull;
                        continue;
                    }
                    TestUtil.logTrace((String)"Check collection for expected balances");
                    for (int l = 0; l < 15; ++l) {
                        if (!expectedBalances[l].equals(b)) continue;
                        ++foundBalance;
                        continue block2;
                    }
                }
                if (numOfNull != 0 || foundBalance != 15) {
                    TestUtil.logErr((String)"selectAllCreditCardBalances did not return expected results");
                    pass2 = false;
                } else {
                    TestUtil.logMsg((String)"Successfully returned expected results");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest27: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest27 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("nullTest27 failed");
        }
    }

    public void nullTest28() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Check CreditCard Balances for Orders");
            o = this.orderHome.findOrdersByQuery22(1000.0);
            expectedPKs = new String[]{"11", "12"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception nullTest28: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("nullTest28 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("nullTest28 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

