/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.api.config;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.api.model.SimpleContainerDeserializer;
import com.sun.ts.tests.jsonb.api.model.SimpleContainerSerializer;
import com.sun.ts.tests.jsonb.api.model.SimpleIntegerAdapter;
import com.sun.ts.tests.jsonb.api.model.SimpleIntegerDeserializer;
import com.sun.ts.tests.jsonb.api.model.SimpleIntegerSerializer;
import com.sun.ts.tests.jsonb.api.model.SimplePropertyNamingStrategy;
import com.sun.ts.tests.jsonb.api.model.SimplePropertyVisibilityStrategy;
import com.sun.ts.tests.jsonb.api.model.SimpleStringAdapter;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.json.bind.config.PropertyNamingStrategy;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class JsonbConfigTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        JsonbConfigTest t = new JsonbConfigTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void testGetAsMap() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true));
        Map configMap = jsonbConfig.getAsMap();
        if (configMap.size() != 2 || !configMap.containsKey("jsonb.formatting") || !configMap.containsKey("jsonb.null-values")) {
            throw new EETest.Fault("Failed to get configuration properties as a map using JsonbConfig.getAsMap method.");
        }
        try {
            configMap.put("jsonb.binary-data-strategy", "BASE_64");
            throw new EETest.Fault("Failed to get configuration properties as an unmodifiable map using JsonbConfig.getAsMap method.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
    }

    public void testGetProperty() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.formatting");
        if (!property.isPresent() || !((Boolean)property.get()).booleanValue()) {
            throw new EETest.Fault("Failed to get a configuration property using JsonbConfig.getProperty method.");
        }
    }

    public void testGetUnsetProperty() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.adapters");
        if (property.isPresent()) {
            throw new EETest.Fault("Failed to get Optional.empty for an unset configuration property using JsonbConfig.getProperty method.");
        }
    }

    public void testSetProperty() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"UPPER_CAMEL_CASE_WITH_SPACES");
        if (!jsonbConfig.getProperty("jsonb.property-naming-strategy").get().equals("UPPER_CAMEL_CASE_WITH_SPACES")) {
            throw new EETest.Fault("Failed to set a property value using JsonbConfig.setProperty method.");
        }
    }

    public void testWithAdapters() throws EETest.Fault {
        SimpleStringAdapter simpleStringAdapter = new SimpleStringAdapter();
        JsonbConfig jsonbConfig = new JsonbConfig().withAdapters(new JsonbAdapter[]{simpleStringAdapter});
        Object adapters = jsonbConfig.getProperty("jsonb.adapters").get();
        if (!JsonbAdapter[].class.isAssignableFrom(adapters.getClass()) || simpleStringAdapter != ((JsonbAdapter[])adapters)[0]) {
            throw new EETest.Fault("Failed to configure a custom adapter using JsonbConfig.withAdapters method.");
        }
    }

    public void testWithAdaptersMultipleCalls() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleIntegerAdapter()}).withAdapters(new JsonbAdapter[]{new SimpleStringAdapter()});
        Object adapters = jsonbConfig.getProperty("jsonb.adapters").get();
        if (!JsonbAdapter[].class.isAssignableFrom(adapters.getClass())) {
            throw new EETest.Fault("Not expected JsobAdapter array but " + adapters.getClass());
        }
        if (((JsonbAdapter[])adapters).length != 2) {
            throw new EETest.Fault("Failed to configure multiple custom adapters using multiple JsonbConfig.withAdapters method calls.");
        }
    }

    public void testWithMultipleAdapters() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleIntegerAdapter(), new SimpleStringAdapter()});
        Object adapters = jsonbConfig.getProperty("jsonb.adapters").get();
        if (!JsonbAdapter[].class.isAssignableFrom(adapters.getClass())) {
            throw new EETest.Fault("Not expected JsobAdapter array but " + adapters.getClass());
        }
        if (((JsonbAdapter[])adapters).length != 2) {
            throw new EETest.Fault("Failed to configure multiple custom adapters using multiple JsonbConfig.withAdapters method calls.");
        }
    }

    public void testWithBinaryDataStrategy() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withBinaryDataStrategy("BASE_64_URL");
        Optional property = jsonbConfig.getProperty("jsonb.binary-data-strategy");
        if (!property.isPresent() || !"BASE_64_URL".equals(property.get())) {
            throw new EETest.Fault("Failed to configure a custom binary data strategy using JsonbConfig.withBinaryDataStrategy method.");
        }
    }

    public void testWithDateFormat() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withDateFormat("YYYYMMDD", Locale.GERMAN);
        Optional property = jsonbConfig.getProperty("jsonb.date-format");
        if (!property.isPresent() || !"YYYYMMDD".equals(property.get())) {
            throw new EETest.Fault("Failed to configure a custom date format using JsonbConfig.withDateFormat method.");
        }
    }

    public void testWithDeserializers() throws EETest.Fault {
        SimpleContainerDeserializer deserializer = new SimpleContainerDeserializer();
        JsonbConfig jsonbConfig = new JsonbConfig().withDeserializers(new JsonbDeserializer[]{deserializer});
        Object deserializers = jsonbConfig.getProperty("jsonb.derializers").get();
        if (!JsonbDeserializer[].class.isAssignableFrom(deserializers.getClass()) || deserializer != ((JsonbDeserializer[])deserializers)[0]) {
            throw new EETest.Fault("Failed to configure a custom deserializer using JsonbConfig.withDeserializers method.");
        }
    }

    public void testWithDeserializersMultipleCalls() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withDeserializers(new JsonbDeserializer[]{new SimpleIntegerDeserializer()}).withDeserializers(new JsonbDeserializer[]{new SimpleContainerDeserializer()});
        Object deserializers = jsonbConfig.getProperty("jsonb.derializers").get();
        if (!JsonbDeserializer[].class.isAssignableFrom(deserializers.getClass())) {
            throw new EETest.Fault("Not expected JsonbDeserializer array but " + deserializers.getClass());
        }
        if (((JsonbDeserializer[])deserializers).length != 2) {
            throw new EETest.Fault("Failed to configure multiple custom deserializers using multiple JsonbConfig.withDeserializers method calls.");
        }
    }

    public void testWithEncoding() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withEncoding("UCS2");
        Optional property = jsonbConfig.getProperty("jsonb.encoding");
        if (!property.isPresent() || !"UCS2".equals(property.get())) {
            throw new EETest.Fault("Failed to configure a custom character encoding using JsonbConfig.withEncoding method.");
        }
    }

    public void testWithFormatting() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.formatting");
        if (!property.isPresent() || !((Boolean)property.get()).booleanValue()) {
            throw new EETest.Fault("Failed to configure JSON string formatting using JsonbConfig.withFormatting method.");
        }
    }

    public void testWithLocale() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withLocale(Locale.GERMAN);
        Optional property = jsonbConfig.getProperty("jsonb.locale");
        if (!property.isPresent() || !Locale.GERMAN.equals(property.get())) {
            throw new EETest.Fault("Failed to configure a custom locale using JsonbConfig.withLocale method.");
        }
    }

    public void testWithNullValues() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withNullValues(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.null-values");
        if (!property.isPresent() || !((Boolean)property.get()).booleanValue()) {
            throw new EETest.Fault("Failed to configure serialization of null values using JsonbConfig.withNullValues method.");
        }
    }

    public void testWithPropertyNamingStrategy() throws EETest.Fault {
        SimplePropertyNamingStrategy propertyNamingStrategy = new SimplePropertyNamingStrategy();
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyNamingStrategy((PropertyNamingStrategy)propertyNamingStrategy);
        Optional property = jsonbConfig.getProperty("jsonb.property-naming-strategy");
        if (!property.isPresent() || propertyNamingStrategy != property.get()) {
            throw new EETest.Fault("Failed to configure a custom property naming strategy using JsonbConfig.withPropertyNamingStrategy method.");
        }
    }

    public void testWithPropertyNamingStrategyString() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyNamingStrategy("UPPER_CAMEL_CASE");
        Optional property = jsonbConfig.getProperty("jsonb.property-naming-strategy");
        if (!property.isPresent() || !"UPPER_CAMEL_CASE".equals(property.get())) {
            throw new EETest.Fault("Failed to configure a custom property naming strategy using JsonbConfig.withPropertyNamingStrategy method with String argument.");
        }
    }

    public void testWithPropertyOrderStrategy() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyOrderStrategy("LEXICOGRAPHICAL");
        Optional property = jsonbConfig.getProperty("jsonb.property-order-strategy");
        if (!property.isPresent() || !"LEXICOGRAPHICAL".equals(property.get())) {
            throw new EETest.Fault("Failed to configure a custom property order strategy using JsonbConfig.withPropertyOrderStrategy method.");
        }
    }

    public void testWithPropertyVisibilityStrategy() throws EETest.Fault {
        SimplePropertyVisibilityStrategy propertyVisibilityStrategy = new SimplePropertyVisibilityStrategy();
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyVisibilityStrategy((PropertyVisibilityStrategy)propertyVisibilityStrategy);
        Optional property = jsonbConfig.getProperty("jsonb.property-visibility-strategy");
        if (!property.isPresent() || propertyVisibilityStrategy != property.get()) {
            throw new EETest.Fault("Failed to configure a custom property visibility strategy using JsonbConfig.withPropertyVisibilityStrategy method.");
        }
    }

    public void testWithSerializers() throws EETest.Fault {
        SimpleContainerSerializer serializer = new SimpleContainerSerializer();
        JsonbConfig jsonbConfig = new JsonbConfig().withSerializers(new JsonbSerializer[]{serializer});
        Object serializers = jsonbConfig.getProperty("jsonb.serializers").get();
        if (!JsonbSerializer[].class.isAssignableFrom(serializers.getClass()) || serializer != ((JsonbSerializer[])serializers)[0]) {
            throw new EETest.Fault("Failed to configure a custom serializer using JsonbConfig.withSerializers method.");
        }
    }

    public void testWithSerializersMultipleCalls() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withSerializers(new JsonbSerializer[]{new SimpleIntegerSerializer()}).withSerializers(new JsonbSerializer[]{new SimpleContainerSerializer()});
        Object serializers = jsonbConfig.getProperty("jsonb.serializers").get();
        if (!JsonbSerializer[].class.isAssignableFrom(serializers.getClass())) {
            throw new EETest.Fault("Not expected JsonbSerializer array but " + serializers.getClass());
        }
        if (((JsonbSerializer[])serializers).length != 2) {
            throw new EETest.Fault("Failed to configure multiple custom serializers using multiple JsonbConfig.withSerializers method calls.");
        }
    }

    public void testWithStrictIJson() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withStrictIJSON(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.strict-ijson");
        if (!property.isPresent() || !((Boolean)property.get()).booleanValue()) {
            throw new EETest.Fault("Failed to configure strict I-JSON support using JsonbConfig.withStrictIJSON method.");
        }
    }
}

