/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.convert;

import com.sun.ts.tests.jpa.core.annotations.convert.DotConverter2;
import com.sun.ts.tests.jpa.core.annotations.convert.Employee3;
import com.sun.ts.tests.jpa.core.annotations.convert.SalaryConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Converts;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name="EMPLOYEE")
@Converts(value={@Convert(attributeName="firstName", converter=DotConverter2.class)})
public class FullTimeEmployee2
extends Employee3
implements Serializable {
    private String salary;

    public FullTimeEmployee2() {
    }

    public FullTimeEmployee2(int id, String firstName, String lastName, String salary) {
        super(id, firstName, lastName);
        this.salary = salary;
    }

    @Column(name="SALARY")
    @Convert(converter=SalaryConverter.class)
    public String getSalary() {
        return this.salary;
    }

    public void setSalary(String salary) {
        this.salary = salary;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", first: " + this.getFirstName());
        result.append(", last: " + this.getLastName());
        result.append(", salary: " + this.getSalary());
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        return this.getId() + this.getFirstName().hashCode() + this.getLastName().hashCode() + this.getSalary().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullTimeEmployee2)) {
            return false;
        }
        FullTimeEmployee2 o1 = (FullTimeEmployee2)o;
        boolean result = false;
        if (this.getId() == o1.getId() && this.getFirstName().equals(o1.getFirstName()) && this.getLastName().equals(o1.getLastName()) && this.getSalary().equals(o1.getSalary())) {
            result = true;
        }
        return result;
    }
}

