/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IdentifyReferencesToMissingEntries
extends LDAPCommandLineTool
implements SearchResultListener {
    private static final long serialVersionUID = 1981894839719501258L;
    private final AtomicLong entriesExamined = new AtomicLong(0L);
    private DNArgument baseDNArgument = null;
    private IntegerArgument pageSizeArgument = null;
    private LDAPConnectionPool getReferencedEntriesPool = null;
    private final Map<String, AtomicLong> missingReferenceCounts = new TreeMap<String, AtomicLong>();
    private String[] attributes;
    private StringArgument attributeArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = IdentifyReferencesToMissingEntries.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        IdentifyReferencesToMissingEntries tool = new IdentifyReferencesToMissingEntries(outStream, errStream);
        return tool.runTool(args);
    }

    public IdentifyReferencesToMissingEntries(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "identify-references-to-missing-entries";
    }

    @Override
    public String getToolDescription() {
        return "This tool may be used to identify entries containing one or more attributes which reference entries that do not exist.  This may require the ability to perform unindexed searches and/or the ability to use the simple paged results control.";
    }

    @Override
    public String getToolVersion() {
        return "4.0.0";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The search base DN(s) to use to find entries with references to other entries.  At least one base DN must be specified.";
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, "{dn}", description);
        this.baseDNArgument.addLongIdentifier("base-dn");
        parser.addArgument(this.baseDNArgument);
        description = "The attribute(s) for which to find missing references.  At least one attribute must be specified, and each attribute must be indexed for equality searches and have values which are DNs.";
        this.attributeArgument = new StringArgument(Character.valueOf('A'), "attribute", true, 0, "{attr}", description);
        parser.addArgument(this.attributeArgument);
        description = "The maximum number of entries to retrieve at a time when attempting to find entries with references to other entries.  This requires that the authenticated user have permission to use the simple paged results control, but it can avoid problems with the server sending entries too quickly for the client to handle.  By default, the simple paged results control will not be used.";
        this.pageSizeArgument = new IntegerArgument(Character.valueOf('z'), "simplePageSize", false, 1, "{num}", description, 1, Integer.MAX_VALUE);
        this.pageSizeArgument.addLongIdentifier("simple-page-size");
        parser.addArgument(this.pageSizeArgument);
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        LDAPConnectionPool findReferencesPool;
        try {
            findReferencesPool = this.getConnectionPool(1, 1);
            findReferencesPool.setRetryFailedOperationsDueToInvalidConnections(true);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
            return le.getResultCode();
        }
        try {
            ResultCode resultCode;
            Filter filter;
            try {
                this.getReferencedEntriesPool = this.getConnectionPool(1, 1);
                this.getReferencedEntriesPool.setRetryFailedOperationsDueToInvalidConnections(true);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
                ResultCode resultCode2 = le.getResultCode();
                findReferencesPool.close();
                if (this.getReferencedEntriesPool != null) {
                    this.getReferencedEntriesPool.close();
                }
                return resultCode2;
            }
            List<String> attrList = this.attributeArgument.getValues();
            this.attributes = new String[attrList.size()];
            attrList.toArray(this.attributes);
            if (this.attributes.length == 1) {
                filter = Filter.createPresenceFilter(this.attributes[0]);
                this.missingReferenceCounts.put(this.attributes[0], new AtomicLong(0L));
            } else {
                Filter[] orComps = new Filter[this.attributes.length];
                for (int i = 0; i < this.attributes.length; ++i) {
                    orComps[i] = Filter.createPresenceFilter(this.attributes[i]);
                    this.missingReferenceCounts.put(this.attributes[i], new AtomicLong(0L));
                }
                filter = Filter.createORFilter(orComps);
            }
            for (DN baseDN : this.baseDNArgument.getValues()) {
                ASN1OctetString cookie = null;
                do {
                    SimplePagedResultsControl pagedResultsResponse;
                    SearchResult searchResult;
                    SearchRequest searchRequest = new SearchRequest((SearchResultListener)this, baseDN.toString(), SearchScope.SUB, filter, this.attributes);
                    if (this.pageSizeArgument.isPresent()) {
                        searchRequest.addControl(new SimplePagedResultsControl(this.pageSizeArgument.getValue(), cookie, false));
                    }
                    try {
                        searchResult = findReferencesPool.search(searchRequest);
                    }
                    catch (LDAPSearchException lse) {
                        Debug.debugException(lse);
                        try {
                            searchResult = findReferencesPool.search(searchRequest);
                        }
                        catch (LDAPSearchException lse2) {
                            Debug.debugException(lse2);
                            searchResult = lse2.getSearchResult();
                        }
                    }
                    if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                        this.err("An error occurred while attempting to search for missing references to entries below " + baseDN + ":  " + searchResult.getDiagnosticMessage());
                        ResultCode lse = searchResult.getResultCode();
                        return lse;
                    }
                    try {
                        pagedResultsResponse = SimplePagedResultsControl.get(searchResult);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.err("An error occurred while attempting to decode a simple paged results response control in the response to a search for entries below " + baseDN + ":  " + StaticUtils.getExceptionMessage(le));
                        ResultCode resultCode3 = le.getResultCode();
                        findReferencesPool.close();
                        if (this.getReferencedEntriesPool != null) {
                            this.getReferencedEntriesPool.close();
                        }
                        return resultCode3;
                    }
                    if (pagedResultsResponse == null) continue;
                    cookie = pagedResultsResponse.moreResultsToReturn() ? pagedResultsResponse.getCookie() : null;
                } while (cookie != null);
            }
            boolean missingReferenceFound = false;
            for (Map.Entry<String, AtomicLong> e : this.missingReferenceCounts.entrySet()) {
                long numMissing = e.getValue().get();
                if (numMissing <= 0L) continue;
                if (!missingReferenceFound) {
                    this.err(new Object[0]);
                    missingReferenceFound = true;
                }
                this.err("Found " + numMissing + ' ' + e.getKey() + " references to entries that do not exist.");
            }
            if (missingReferenceFound) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return resultCode;
            }
            this.out("No references were found to entries that do not exist.");
            resultCode = ResultCode.SUCCESS;
            return resultCode;
        }
        finally {
            findReferencesPool.close();
            if (this.getReferencedEntriesPool != null) {
                this.getReferencedEntriesPool.close();
            }
        }
    }

    public Map<String, AtomicLong> getMissingReferenceCounts() {
        return Collections.unmodifiableMap(this.missingReferenceCounts);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=john.doe,ou=People,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--attribute", "member", "--attribute", "uniqueMember", "--simplePageSize", "100"};
        exampleMap.put(args, "Identify all entries below dc=example,dc=com in which either the member or uniqueMember attribute references an entry that does not exist.");
        return exampleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        long count;
        try {
            for (String attr : this.attributes) {
                List<Attribute> attrList = searchEntry.getAttributesWithOptions(attr, null);
                for (Attribute a : attrList) {
                    for (String value : a.getValues()) {
                        try {
                            SearchResultEntry e = this.getReferencedEntriesPool.getEntry(value, "1.1");
                            if (e != null) continue;
                            this.err("Entry '", searchEntry.getDN(), "' includes attribute ", a.getName(), " that references entry '", value, "' which does not exist.");
                            this.missingReferenceCounts.get(attr).incrementAndGet();
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.err("An error occurred while attempting to determine whether entry '" + value + "' referenced in attribute " + a.getName() + " of entry '" + searchEntry.getDN() + "' exists:  " + StaticUtils.getExceptionMessage(le));
                            this.missingReferenceCounts.get(attr).incrementAndGet();
                        }
                    }
                }
            }
            count = this.entriesExamined.incrementAndGet();
            if (count % 1000L != 0L) return;
        }
        catch (Throwable throwable) {
            long count2 = this.entriesExamined.incrementAndGet();
            if (count2 % 1000L != 0L) throw throwable;
            this.out(count2, " entries examined");
            throw throwable;
        }
        this.out(count, " entries examined");
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
    }
}

