/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneralMonitorEntry
extends MonitorEntry {
    static final String GENERAL_MONITOR_OC = "ds-general-monitor-entry";
    private static final String ATTR_CURRENT_CONNECTIONS = "currentConnections";
    private static final String ATTR_CURRENT_TIME = "currentTime";
    private static final String ATTR_DEGRADED_ALERT_TYPE = "degraded-alert-type";
    private static final String ATTR_INSTANCE_NAME = "instanceName";
    private static final String ATTR_MAX_CONNECTIONS = "maxConnections";
    private static final String ATTR_PRODUCT_NAME = "productName";
    private static final String ATTR_START_TIME = "startTime";
    private static final String ATTR_STARTUP_ID = "startupID";
    private static final String ATTR_STARTUP_UUID = "startupUUID";
    private static final String ATTR_THIRD_PARTY_EXTENSION_DN = "thirdPartyExtensionDN";
    private static final String ATTR_TOTAL_CONNECTIONS = "totalConnections";
    private static final String ATTR_UP_TIME = "upTime";
    private static final String ATTR_VENDOR_NAME = "productVendor";
    private static final String ATTR_VERSION = "productVersion";
    private static final String ATTR_UNAVAILABLE_ALERT_TYPE = "unavailable-alert-type";
    private static final long serialVersionUID = 4262569940859462743L;
    private final Date currentTime;
    private final Date startTime;
    private final List<String> degradedAlertTypes;
    private final List<String> thirdPartyExtensionDNs;
    private final List<String> unavailableAlertTypes;
    private final Long currentConnections = this.getLong("currentConnections");
    private final Long maxConnections;
    private final Long totalConnections;
    private final String instanceName;
    private final String productName;
    private final String startupID;
    private final String startupUUID;
    private final String uptime;
    private final String vendorName;
    private final String versionString;

    public GeneralMonitorEntry(Entry entry) {
        super(entry);
        this.currentTime = this.getDate(ATTR_CURRENT_TIME);
        this.maxConnections = this.getLong(ATTR_MAX_CONNECTIONS);
        this.productName = this.getString(ATTR_PRODUCT_NAME);
        this.startTime = this.getDate(ATTR_START_TIME);
        this.instanceName = this.getString(ATTR_INSTANCE_NAME);
        this.startupID = this.getString(ATTR_STARTUP_ID);
        this.startupUUID = this.getString(ATTR_STARTUP_UUID);
        this.totalConnections = this.getLong(ATTR_TOTAL_CONNECTIONS);
        this.uptime = this.getString(ATTR_UP_TIME);
        this.vendorName = this.getString(ATTR_VENDOR_NAME);
        this.versionString = this.getString(ATTR_VERSION);
        this.degradedAlertTypes = this.getStrings(ATTR_DEGRADED_ALERT_TYPE);
        this.unavailableAlertTypes = this.getStrings(ATTR_UNAVAILABLE_ALERT_TYPE);
        this.thirdPartyExtensionDNs = this.getStrings(ATTR_THIRD_PARTY_EXTENSION_DN);
    }

    public Long getCurrentConnections() {
        return this.currentConnections;
    }

    public Long getMaxConnections() {
        return this.maxConnections;
    }

    public Long getTotalConnections() {
        return this.totalConnections;
    }

    public Date getCurrentTime() {
        return this.currentTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getStartupID() {
        return this.startupID;
    }

    public String getStartupUUID() {
        return this.startupUUID;
    }

    public Long getUptimeMillis() {
        if (this.currentTime == null || this.startTime == null) {
            return null;
        }
        return this.currentTime.getTime() - this.startTime.getTime();
    }

    public String getUptimeString() {
        return this.uptime;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public List<String> getDegradedAlertTypes() {
        return this.degradedAlertTypes;
    }

    public List<String> getUnavailableAlertTypes() {
        return this.unavailableAlertTypes;
    }

    public List<String> getThirdPartyExtensionDNs() {
        return this.thirdPartyExtensionDNs;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_GENERAL_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_GENERAL_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.productName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_PRODUCT_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_PRODUCT_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_PRODUCT_NAME.get(), this.productName);
        }
        if (this.vendorName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_VENDOR_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_VENDOR_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_VENDOR_NAME.get(), this.vendorName);
        }
        if (this.versionString != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_VERSION, MonitorMessages.INFO_GENERAL_DISPNAME_VERSION.get(), MonitorMessages.INFO_GENERAL_DESC_VERSION.get(), this.versionString);
        }
        if (this.instanceName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_INSTANCE_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_INSTANCE_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_INSTANCE_NAME.get(), this.instanceName);
        }
        if (this.startTime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_START_TIME, MonitorMessages.INFO_GENERAL_DISPNAME_START_TIME.get(), MonitorMessages.INFO_GENERAL_DESC_START_TIME.get(), this.startTime);
        }
        if (this.startupID != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_STARTUP_ID, MonitorMessages.INFO_GENERAL_DISPNAME_STARTUP_ID.get(), MonitorMessages.INFO_GENERAL_DESC_STARTUP_ID.get(), this.startupID);
        }
        if (this.startupUUID != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_STARTUP_UUID, MonitorMessages.INFO_GENERAL_DISPNAME_STARTUP_UUID.get(), MonitorMessages.INFO_GENERAL_DESC_STARTUP_UUID.get(), this.startupUUID);
        }
        if (this.currentTime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_TIME, MonitorMessages.INFO_GENERAL_DISPNAME_CURRENT_TIME.get(), MonitorMessages.INFO_GENERAL_DESC_CURRENT_TIME.get(), this.currentTime);
        }
        if (this.uptime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_UP_TIME, MonitorMessages.INFO_GENERAL_DISPNAME_UPTIME.get(), MonitorMessages.INFO_GENERAL_DESC_UPTIME.get(), this.uptime);
        }
        if (this.startTime != null && this.currentTime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, "upTimeMillis", MonitorMessages.INFO_GENERAL_DISPNAME_UPTIME_MILLIS.get(), MonitorMessages.INFO_GENERAL_DESC_UPTIME_MILLIS.get(), this.currentTime.getTime() - this.startTime.getTime());
        }
        if (this.currentConnections != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_CONNECTIONS, MonitorMessages.INFO_GENERAL_DISPNAME_CURRENT_CONNECTIONS.get(), MonitorMessages.INFO_GENERAL_DESC_CURRENT_CONNECTIONS.get(), this.currentConnections);
        }
        if (this.maxConnections != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_CONNECTIONS, MonitorMessages.INFO_GENERAL_DISPNAME_MAX_CONNECTIONS.get(), MonitorMessages.INFO_GENERAL_DESC_MAX_CONNECTIONS.get(), this.maxConnections);
        }
        if (this.totalConnections != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_CONNECTIONS, MonitorMessages.INFO_GENERAL_DISPNAME_TOTAL_CONNECTIONS.get(), MonitorMessages.INFO_GENERAL_DESC_TOTAL_CONNECTIONS.get(), this.totalConnections);
        }
        if (!this.degradedAlertTypes.isEmpty()) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_DEGRADED_ALERT_TYPE, MonitorMessages.INFO_GENERAL_DISPNAME_DEGRADED_ALERT_TYPE.get(), MonitorMessages.INFO_GENERAL_DESC_DEGRADED_ALERT_TYPE.get(), this.degradedAlertTypes);
        }
        if (!this.unavailableAlertTypes.isEmpty()) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_UNAVAILABLE_ALERT_TYPE, MonitorMessages.INFO_GENERAL_DISPNAME_UNAVAILABLE_ALERT_TYPE.get(), MonitorMessages.INFO_GENERAL_DESC_UNAVAILABLE_ALERT_TYPE.get(), this.unavailableAlertTypes);
        }
        if (!this.thirdPartyExtensionDNs.isEmpty()) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_THIRD_PARTY_EXTENSION_DN, MonitorMessages.INFO_GENERAL_DISPNAME_THIRD_PARTY_EXTENSION_DN.get(), MonitorMessages.INFO_GENERAL_DESC_THIRD_PARTY_EXTENSION_DN.get(), this.thirdPartyExtensionDNs);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

