/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RestoreTask
extends Task {
    static final String RESTORE_TASK_CLASS = "com.unboundid.directory.server.tasks.RestoreTask";
    private static final String ATTR_BACKUP_DIRECTORY = "ds-backup-directory-path";
    private static final String ATTR_BACKUP_ID = "ds-backup-id";
    private static final String ATTR_VERIFY_ONLY = "ds-task-restore-verify-only";
    private static final String OC_RESTORE_TASK = "ds-task-restore";
    private static final TaskProperty PROPERTY_BACKUP_DIRECTORY = new TaskProperty("ds-backup-directory-path", TaskMessages.INFO_DISPLAY_NAME_BACKUP_DIRECTORY.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_DIRECTORY_RESTORE.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_BACKUP_ID = new TaskProperty("ds-backup-id", TaskMessages.INFO_DISPLAY_NAME_BACKUP_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_ID_RESTORE.get(), String.class, false, false, true);
    private static final TaskProperty PROPERTY_VERIFY_ONLY = new TaskProperty("ds-task-restore-verify-only", TaskMessages.INFO_DISPLAY_NAME_VERIFY_ONLY.get(), TaskMessages.INFO_DESCRIPTION_VERIFY_ONLY.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = -196339437379274643L;
    private final boolean verifyOnly;
    private final String backupDirectory;
    private final String backupID;

    public RestoreTask() {
        this.verifyOnly = false;
        this.backupDirectory = null;
        this.backupID = null;
    }

    public RestoreTask(String taskID, String backupDirectory, String backupID, boolean verifyOnly) {
        this(taskID, backupDirectory, backupID, verifyOnly, null, null, null, null, null);
    }

    public RestoreTask(String taskID, String backupDirectory, String backupID, boolean verifyOnly, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, RESTORE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        Validator.ensureNotNull(backupDirectory);
        this.backupDirectory = backupDirectory;
        this.backupID = backupID;
        this.verifyOnly = verifyOnly;
    }

    public RestoreTask(Entry entry) throws TaskException {
        super(entry);
        this.backupDirectory = entry.getAttributeValue(ATTR_BACKUP_DIRECTORY);
        if (this.backupDirectory == null) {
            throw new TaskException(TaskMessages.ERR_RESTORE_NO_BACKUP_DIRECTORY.get(this.getTaskEntryDN()));
        }
        this.backupID = entry.getAttributeValue(ATTR_BACKUP_ID);
        this.verifyOnly = RestoreTask.parseBooleanValue(entry, ATTR_VERIFY_ONLY, false);
    }

    public RestoreTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(RESTORE_TASK_CLASS, properties);
        boolean v = false;
        String b = null;
        String i = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKUP_DIRECTORY)) {
                b = RestoreTask.parseString(p, values, b);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_BACKUP_ID)) {
                i = RestoreTask.parseString(p, values, i);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_VERIFY_ONLY)) continue;
            v = RestoreTask.parseBoolean(p, values, v);
        }
        if (b == null) {
            throw new TaskException(TaskMessages.ERR_RESTORE_NO_BACKUP_DIRECTORY.get(this.getTaskEntryDN()));
        }
        this.backupDirectory = b;
        this.backupID = i;
        this.verifyOnly = v;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_RESTORE.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_RESTORE.get();
    }

    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    public String getBackupID() {
        return this.backupID;
    }

    public boolean verifyOnly() {
        return this.verifyOnly;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_RESTORE_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(3);
        attrs.add(new Attribute(ATTR_BACKUP_DIRECTORY, this.backupDirectory));
        attrs.add(new Attribute(ATTR_VERIFY_ONLY, String.valueOf(this.verifyOnly)));
        if (this.backupID != null) {
            attrs.add(new Attribute(ATTR_BACKUP_ID, this.backupID));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BACKUP_DIRECTORY, PROPERTY_BACKUP_ID, PROPERTY_VERIFY_ONLY);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        props.put(PROPERTY_BACKUP_DIRECTORY, Collections.unmodifiableList(Arrays.asList(this.backupDirectory)));
        if (this.backupID == null) {
            props.put(PROPERTY_BACKUP_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_BACKUP_ID, Collections.unmodifiableList(Arrays.asList(this.backupID)));
        }
        props.put(PROPERTY_VERIFY_ONLY, Collections.unmodifiableList(Arrays.asList(this.verifyOnly)));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

