/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SynchronizedSocketFactory
extends SocketFactory {
    private final SocketFactory factory;

    public SynchronizedSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    public SocketFactory getWrappedSocketFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SocketFactory socketFactory = this.factory;
        synchronized (socketFactory) {
            return this.factory.createSocket(host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        SocketFactory socketFactory = this.factory;
        synchronized (socketFactory) {
            return this.factory.createSocket(host, port, localAddress, localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        SocketFactory socketFactory = this.factory;
        synchronized (socketFactory) {
            return this.factory.createSocket(address, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SocketFactory socketFactory = this.factory;
        synchronized (socketFactory) {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }
    }
}

