/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.AbortedException;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.enterprise.concurrent.AbortedException;
import java.io.Serializable;
import java.util.Properties;

public class Client
extends ServiceEETest
implements Serializable {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void AbortedExceptionNoArgTest() throws EETest.Fault {
        boolean pass = false;
        try {
            throw new AbortedException();
        }
        catch (AbortedException ae) {
            TestUtil.logTrace((String)"AbortedException Caught as Expected");
            if (ae.getMessage() == null) {
                TestUtil.logTrace((String)"Received expected null message");
                pass = true;
            } else {
                TestUtil.logErr((String)("AbortedException should have had null message, actual message=" + ae.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("AbortedExceptionNoArgTest failed");
        }
    }

    public void AbortedExceptionStringTest() throws EETest.Fault {
        boolean pass = false;
        String expected = "thisisthedetailmessage";
        try {
            throw new AbortedException(expected);
        }
        catch (AbortedException ae) {
            TestUtil.logTrace((String)"AbortedException Caught as Expected");
            if (ae.getMessage().equals(expected)) {
                TestUtil.logTrace((String)"Received expected message");
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected:" + expected + ", actual message=" + ae.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("AbortedExceptionStringTest failed");
        }
    }

    public void AbortedExceptionThrowableTest() throws EETest.Fault {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        Throwable expected = new Throwable("thisisthethrowable");
        try {
            throw new AbortedException(expected);
        }
        catch (AbortedException ae) {
            TestUtil.logTrace((String)"AbortedException Caught as Expected");
            cause = ae.getCause();
            if (cause.equals(expected)) {
                TestUtil.logTrace((String)"Received expected cause");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + expected + ", actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        expected = null;
        try {
            throw new AbortedException(expected);
        }
        catch (AbortedException ae) {
            TestUtil.logTrace((String)"AbortedException Caught as Expected");
            cause = ae.getCause();
            if (cause == null) {
                TestUtil.logTrace((String)"Received expected null cause");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected:null, actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("AbortedExceptionThrowableTest failed");
        }
    }

    public void AbortedExceptionStringThrowableTest() throws EETest.Fault {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "thisisthedetailmessage";
        Throwable tExpected = new Throwable("thisisthethrowable");
        try {
            throw new AbortedException(sExpected, tExpected);
        }
        catch (AbortedException ae) {
            TestUtil.logTrace((String)"AbortedException Caught as Expected");
            if (ae.getMessage().equals(sExpected)) {
                TestUtil.logTrace((String)"Received expected message");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + sExpected + ", actual message=" + ae.getMessage()));
            }
            cause = ae.getCause();
            if (cause.equals(tExpected)) {
                TestUtil.logTrace((String)"Received expected cause");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + tExpected + ", actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        tExpected = null;
        try {
            throw new AbortedException(sExpected, tExpected);
        }
        catch (AbortedException ae) {
            TestUtil.logTrace((String)"AbortedException Caught as Expected");
            if (ae.getMessage().equals(sExpected)) {
                TestUtil.logTrace((String)"Received expected message");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + sExpected + ", actual message=" + ae.getMessage()));
            }
            cause = ae.getCause();
            if (cause == null) {
                TestUtil.logTrace((String)"Received expected null cause");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Expected:null, actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("AbortedExceptionStringThrowableTest failed");
        }
    }
}

