/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.collectiontable;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.collectiontable.A;
import com.sun.ts.tests.jpa.core.annotations.collectiontable.Address;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionTable1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin collectionTable1");
        boolean pass = false;
        A aRef = null;
        Object bCol = null;
        Object newCol = null;
        try {
            TestUtil.logTrace((String)"New instances");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("Some Address", "Boston", "MA", "01803");
            HashSet<Address> s1 = new HashSet<Address>();
            s1.add(addr1);
            s1.add(addr2);
            aRef = new A("1", "bean1", 1);
            aRef.setAddress(s1);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)aRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            A newA = this.findA("1");
            Set newAddressSet = newA.getAddress();
            this.dumpAddresses(newAddressSet);
            boolean pass1 = false;
            boolean pass2 = false;
            for (Address addr : newAddressSet) {
                if (addr.getStreet().equals("1 Network Drive") && addr.getCity().equals("Burlington") && addr.getState().equals("MA") && addr.getZip().equals("01801")) {
                    pass1 = true;
                    TestUtil.logTrace((String)("pass1 = " + pass1));
                }
                if (!addr.getStreet().equals("Some Address") || !addr.getCity().equals("Boston") || !addr.getState().equals("MA") || !addr.getZip().equals("01803")) continue;
                pass2 = true;
                TestUtil.logTrace((String)("pass2 = " + pass2));
            }
            if (pass1 && pass2) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("collectionTable1 failed");
        }
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void dumpAddresses(Set<Address> addr) {
        TestUtil.logTrace((String)"address Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("size=" + addr.size()));
        int elem = 1;
        for (Address v : addr) {
            TestUtil.logTrace((String)("- Element #" + elem++));
            if (v != null) {
                TestUtil.logTrace((String)("  street=" + v.getStreet() + ", city=" + v.getCity() + ", state=" + v.getState() + ", zip=" + v.getZip()));
                continue;
            }
            TestUtil.logTrace((String)"  address=numm");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COLTAB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

