/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.initorder.appclientejb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.assembly.initorder.common.InitOrderRemoteIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public class Client
extends EETest {
    @Resource(lookup="java:app/AppName")
    private static String appNameInjected;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) {
    }

    public void cleanup() {
    }

    private static HelloRemoteIF getHelloBean() {
        return (HelloRemoteIF)ServiceLocator.lookupNoTry(HelloRemoteIF.GLOBAL_JNDI_NAME, new Context[0]);
    }

    public void initOrder() {
        List<String> expected = Arrays.asList("InitOrder2Bean", "InitOrderBean");
        List<String> records = Client.getHelloBean().getAndClearRecords();
        Helper.getLogger().info(Helper.assertEquals(null, expected, records));
    }

    public void appName() {
        String[] moduleAndBeanNames;
        String expected = "renamed2";
        String lookup = "java:app/AppName";
        String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual);
        Helper.assertEquals("Check appNameInjected ", expected, appNameInjected);
        Helper.getLogger().info("Got expected " + lookup + ": " + actual);
        for (String m : moduleAndBeanNames = new String[]{"one_ejb/InitOrderBean", "two_ejb/InitOrder2Bean"}) {
            StringBuilder reason = new StringBuilder();
            String s = "java:global/renamed2/" + m;
            InitOrderRemoteIF b = (InitOrderRemoteIF)ServiceLocator.lookupNoTry(s, new Context[0]);
            reason.append(String.format("Looked up by global jndi name %s, and got %s", s, b));
            s = "java:global/ejb3_assembly_initorder_appclientejb/" + m;
            try {
                b = (InitOrderRemoteIF)ServiceLocator.lookup(s, new Context[0]);
                throw new RuntimeException("Expecting NamingException when looking up " + s + ", but got " + b);
            }
            catch (NamingException e) {
                reason.append(" Got expected ").append(e).append(" when looking up ").append(s);
                Helper.getLogger().info(reason.toString());
            }
        }
    }
}

