/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getAllHeaders()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	     Return all the headers from this part as an Enumeration of Header objects. <p>
 * api2test: public Enumeration getAllHeaders()  <p>
 *
 * how2test: Call this API, then enumerate all headers fetched by this method, if <p>
 *	     this operation is successfull the testcase passes, otherwise it fails.
 */

public class getAllHeaders_Test extends MailTest {

    public static void main( String argv[] )
    {
        getAllHeaders_Test test = new getAllHeaders_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: getAllHeaders()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
                 return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }

             for(int i = 1; i <= msgcount; i++)
             {
            // Get the message

               Message msg = folder.getMessage(i);
	       if ( msg == null ) {
		   return Status.failed("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
	       }
	    // BEGIN UNIT TEST:
		// Get all headers for given message(s)
	       out.println("UNIT TEST "+ i +":  getAllHeaders()");

	       Enumeration allheaders = msg.getAllHeaders();	// API TEST

	       while ( allheaders.hasMoreElements() ) {
		     Header headers = (Header)allheaders.nextElement();
		     out.println(headers.getName());
	       }
               out.println("UNIT TEST "+ i +":  passed\n");
	    // END UNIT TEST:
	    }
	    folder.close(false);
	    store.close();
	    checkStatus();

        } catch ( Exception e ) {
	    handlException(e);
        }
	return status;
     }
}
