/*
 * Copyright (c) 2002-2012 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.InternetAddress;

import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

public class utilmethods_Test extends MailTest {

    public static void main (String argv[])
    {
	utilmethods_Test test = new utilmethods_Test();
	Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String[] argv, PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting InternetAddress class utility APIs => equals(), toString()\n");

	try {
	  // BEGIN UNIT TEST:
	     InternetAddress addr = new InternetAddress(to);

	     if ( addr == null ) {
		  return Status.failed("Invalid/Null InternetAddress object!");
	     }
	     out.println("UNIT TEST 1:  equals()\n");

	     if (addr.toString().equals( addr.toString() ))	    // API TEST
		  out.println("UNIT TEST 1:  passed\n");
	     else {
		   out.println("UNIT TEST 1:  FAILED\n");
		   errors++;
	     }

	     out.println("\nUNIT TEST 2:  toString()");
	     out.println(addr.toString());

	     if ( addr.toString() != null )		// API TEST
		  out.println("UNIT TEST 2:  passed\n");
             else {
                   out.println("UNIT TEST 2:  FAILED\n");
		   errors++;
             }
	  // END UNIT TEST:

	     checkStatus();
        } catch (Exception e) {
	     handlException(e);
          }
	  return status;
    }
}
