/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.search.SubjectTerm;

import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.search.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>SubjectTerm()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		A contructor that takes 'pattern' string argument. <p>
 * api2test: public SubjectTerm(String)  <p>
 *		The match method.   <p>
 * api2test: boolean match(Message)  <p>
 *
 * how2test: Call these APIs with pattern/string/message arguments and if
 *	     'match' returns boolean value, then this testcase passes.
 */

public class subjectterm_Test extends MailTest {

    public static void main( String argv[] )
    {
        subjectterm_Test test = new subjectterm_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	pattern = "java mail";
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class SubjectTerm: SubjectTerm(String)\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if ( folder == null ) {
                  return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	  // BEGIN UNIT TEST 1:
             out.println("UNIT TEST 1:  SubjectTerm("+ pattern +")");

	     SubjectTerm st = new SubjectTerm(pattern);	// API TEST

             if( st == null ) {
                 return Status.failed("Warning: SubjectTerm contructor returned a Null object!");
	     } else {
		     out.println("UNIT TEST 1: passed\n");
	     }
	  // END UNIT TEST 1:

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }
	     boolean foundit;

             for( int i = 1; i <= msgcount; i++ )
             {
             // Get the message
                MimeMessage msg =  (MimeMessage)folder.getMessage(i);

	        if( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	        }
	     // BEGIN UNIT TEST:
	        out.println("UNIT TEST "+ (i+1) +":  match(Message)");

		// find the pattern in subject
		foundit = st.match(msg);	// API TEST

	        if( foundit ) {
	            out.println("Pattern "+ pattern +" found in message's subject.");
                    out.println("UNIT TEST "+ (i+1) +":  passed\n");
	        } else {
		        out.println("Pattern "+ pattern +" not found in message's subject!");
			out.println("UNIT TEST "+ (i+1) +":  passed\n");
	        }
	     // END UNIT TEST:
	     }
	     folder.close(false);
	     store.close();
	     status = Status.passed("OKAY");

        } catch ( Exception e ) {
             handlException(e);
        }
	return status;
     }
}
