/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.props.stringops;

import java.text.ParsePosition;
import org.apache.ant.props.RegexBasedEvaluator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

public abstract class PatternOperation
extends RegexBasedEvaluator {
    private static final PatternParser[] GREEDY_PARSERS = new PatternParser[]{new RecognizeCrossPlatformSeparators(), new PreserveEscapes(), new CharToPattern('?', "."), new CharToPattern('.', "\\."), new CharToPattern('*', ".*")};
    private static final PatternParser[] RELUCTANT_PARSERS = new PatternParser[]{new RecognizeCrossPlatformSeparators(), new PreserveEscapes(), new CharToPattern('?', "."), new CharToPattern('.', "\\."), new CharToPattern('*', ".*?")};

    protected PatternOperation(String regex) {
        super(regex);
    }

    protected void convertToRegex(StringBuffer sb) {
        this.convertToRegex(sb, true);
    }

    protected void convertToRegex(StringBuffer sb, boolean greedy) {
        PatternParser[] parsers;
        ParsePosition pos = new ParsePosition(0);
        PatternParser[] patternParserArray = parsers = greedy ? GREEDY_PARSERS : RELUCTANT_PARSERS;
        block0: while (pos.getIndex() < sb.length()) {
            for (int i = 0; i < parsers.length; ++i) {
                if (parsers[i].process(sb, pos)) continue block0;
            }
            pos.setIndex(pos.getIndex() + 1);
        }
    }

    protected String toRegex(String pattern) {
        return this.toRegex(pattern, true);
    }

    protected String toRegex(String pattern, boolean greedy) {
        PatternParser[] parsers;
        if (pattern == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(pattern);
        ParsePosition pos = new ParsePosition(0);
        PatternParser[] patternParserArray = parsers = greedy ? GREEDY_PARSERS : RELUCTANT_PARSERS;
        block0: while (pos.getIndex() < sb.length()) {
            for (int i = 0; i < parsers.length; ++i) {
                if (parsers[i].process(sb, pos)) continue block0;
            }
            pos.setIndex(pos.getIndex() + 1);
        }
        return sb.toString();
    }

    protected Regexp createRegexp(String pattern, Project project) {
        RegularExpression re = new RegularExpression();
        re.setPattern(pattern);
        return re.getRegexp(project);
    }

    protected void deEscape(char c, StringBuffer sb) {
        ParsePosition pos = new ParsePosition(0);
        int index = pos.getIndex();
        while (index < sb.length()) {
            if (sb.charAt(index) == '\\' && sb.charAt(index + 1) == c) {
                sb.deleteCharAt(index);
            }
            pos.setIndex(index + 1);
            index = pos.getIndex();
        }
    }

    private static class CharToPattern
    implements PatternParser {
        private char patternChar;
        private String regexpPattern;

        CharToPattern(char patternChar, String regexpPattern) {
            this.patternChar = patternChar;
            this.regexpPattern = regexpPattern;
        }

        public boolean process(StringBuffer sb, ParsePosition pos) {
            int index = pos.getIndex();
            if (sb.charAt(index) == this.patternChar) {
                sb.replace(index, index + 1, this.regexpPattern);
                pos.setIndex(index + this.regexpPattern.length());
                return true;
            }
            return false;
        }
    }

    private static class PreserveEscapes
    implements PatternParser {
        private PreserveEscapes() {
        }

        public boolean process(StringBuffer sb, ParsePosition pos) {
            int index = pos.getIndex();
            if (sb.charAt(index) == '\\') {
                pos.setIndex(index + 2);
                return true;
            }
            return false;
        }
    }

    private static class RecognizeCrossPlatformSeparators
    implements PatternParser {
        private RecognizeCrossPlatformSeparators() {
        }

        public boolean process(StringBuffer sb, ParsePosition pos) {
            int matchLength;
            int index = pos.getIndex();
            int n = sb.indexOf("\\\\", index) == index ? 2 : (matchLength = sb.charAt(index) == '/' ? 1 : 0);
            if (matchLength > 0) {
                sb.replace(index, index + matchLength, "[/|\\\\]");
                pos.setIndex(index + 6);
                return true;
            }
            return false;
        }
    }

    private static interface PatternParser {
        public boolean process(StringBuffer var1, ParsePosition var2);
    }
}

