/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTextArea
extends ClickableElement
implements DisabledElement,
SubmittableElement {
    private static final long serialVersionUID = 4572856255042499634L;
    public static final String TAG_NAME = "textarea";
    private String defaultValue_;
    private int selectionStart_;
    private int selectionEnd_;
    private boolean preventDefault_;

    HtmlTextArea(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    private void initDefaultValue() {
        if (this.defaultValue_ == null) {
            DomText child = (DomText)this.getFirstChild();
            if (child != null) {
                this.defaultValue_ = child.getData();
                if (this.defaultValue_ == null) {
                    this.defaultValue_ = "";
                }
            } else {
                this.defaultValue_ = "";
            }
        }
    }

    public final String getText() {
        return this.getChildrenAsText();
    }

    public final void setText(String newValue) {
        this.initDefaultValue();
        DomText child = (DomText)this.getFirstChild();
        if (child == null) {
            DomText newChild = new DomText(this.getPage(), newValue);
            this.appendChild(newChild);
        } else {
            child.setData(newValue);
        }
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        this.setSelectionStart(newValue.length());
        this.setSelectionEnd(newValue.length());
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getText())};
    }

    @Override
    public void reset() {
        this.initDefaultValue();
        this.setText(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.initDefaultValue();
        this.defaultValue_ = defaultValue == null ? "" : defaultValue;
    }

    @Override
    public String getDefaultValue() {
        this.initDefaultValue();
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getRowsAttribute() {
        return this.getAttributeValue("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttributeValue("cols");
    }

    @Override
    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }

    public String getSelectedText() {
        String text = null;
        if (this.selectionStart_ != this.selectionEnd_) {
            text = this.getText().substring(this.selectionStart_, this.selectionEnd_);
        }
        return text;
    }

    public int getSelectionStart() {
        return this.selectionStart_;
    }

    public void setSelectionStart(int selectionStart) {
        int length;
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionStart > (length = this.getText().length())) {
            selectionStart = length;
        }
        if (this.selectionEnd_ < selectionStart) {
            this.selectionEnd_ = selectionStart;
        }
        this.selectionStart_ = selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd_;
    }

    public void setSelectionEnd(int selectionEnd) {
        int length;
        if (selectionEnd < 0) {
            selectionEnd = 0;
        }
        if (selectionEnd > (length = this.getText().length())) {
            selectionEnd = length;
        }
        if (selectionEnd < this.selectionStart_) {
            this.selectionStart_ = selectionEnd;
        }
        this.selectionEnd_ = selectionEnd;
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(this.getText());
        printWriter.print(indent + "</textarea>");
    }

    @Override
    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this.isDisabled()) {
            return this.getPage();
        }
        this.preventDefault_ = false;
        return super.type(c, shiftKey, ctrlKey, altKey);
    }

    @Override
    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        if (this.preventDefault_) {
            return;
        }
        String text = this.getText();
        if (c == '\b') {
            if (text.length() > 0) {
                this.setText(text.substring(0, text.length() - 1));
            }
        } else if (c == ' ' || c == '\n' || c == '\r' || !Character.isWhitespace(c)) {
            this.setText(text + c);
        }
    }

    @Override
    protected void preventDefault() {
        this.preventDefault_ = true;
    }

    public void select() {
        this.focus();
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
    }
}

