/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import java.util.ResourceBundle;

public class Startup {
    private Frame frame;
    private Image image;
    private Dimension imageSize;

    public Startup() {
        this.showDefault();
    }

    public Startup(I18NResourceBundle i18n, String prefix) {
        this.show(i18n, prefix);
    }

    public Startup(URL url) {
        this.show(url, I18NResourceBundle.getBundleForClass(Startup.class), "startup");
    }

    private void showDefault() {
        this.show(I18NResourceBundle.getBundleForClass(Startup.class), "startup");
    }

    private void show(I18NResourceBundle i18n, String prefix) {
        String iconName = i18n.getOptionalString(prefix + ".icon");
        URL url = null;
        if (iconName != null) {
            url = this.getClass().getClassLoader().getResource(iconName);
        }
        if (url == null) {
            this.showDefault();
        } else {
            this.show(url, i18n, prefix);
        }
    }

    private void show(URL iconURL, I18NResourceBundle i18n, String prefix) {
        this.image = Toolkit.getDefaultToolkit().createImage(iconURL);
        Canvas c = new Canvas(){

            @Override
            public Dimension getPreferredSize() {
                return Startup.this.imageSize;
            }

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }

            @Override
            public void paint(Graphics g) {
                g.drawImage(Startup.this.image, 0, 0, null);
            }
        };
        c.setFocusable(false);
        try {
            MediaTracker t = new MediaTracker(c);
            t.addImage(this.image, 0);
            t.waitForAll();
            this.imageSize = new Dimension(this.image.getWidth(null), this.image.getHeight(null));
            this.frame = new Frame();
            this.setAccessibleInfo(this.frame, i18n, prefix + ".splash");
            this.frame.setUndecorated(true);
            this.frame.setFocusableWindowState(false);
            this.frame.add(c);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.imageSize == null) {
            this.frame = new Frame(ProductInfo.getName() + " " + ProductInfo.getVersion());
            this.setAccessibleInfo(this.frame, i18n, prefix + ".splash");
            this.frame.setBackground(Color.white);
            this.frame.add((Component)new Label(i18n.getString(prefix + ".line1"), 1), "North");
            this.frame.add((Component)new Label(i18n.getString(prefix + ".line2"), 1), "Center");
            this.frame.add((Component)new Label(i18n.getString(prefix + ".line3"), 1), "South");
            this.frame.add((Component)new Label("          "), "East");
            this.frame.add((Component)new Label("           "), "West");
            this.frame.setResizable(false);
        }
        this.frame.pack();
        Dimension size = this.frame.getSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.frame.setLocation(ge.getCenterPoint().x - size.width / 2, ge.getCenterPoint().y - size.height / 2);
        this.frame.setVisible(true);
    }

    Window getWindow() {
        return this.frame;
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void disposeLater() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Startup.this.dispose();
            }
        });
    }

    private void setAccessibleInfo(Frame f, ResourceBundle i18n, String uiKey) {
        f.getAccessibleContext().setAccessibleName(i18n.getString(uiKey + ".name"));
        f.getAccessibleContext().setAccessibleDescription(i18n.getString(uiKey + ".desc"));
    }
}

