/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.configuration.DirectReferenceStrategyInfo;
import com.sun.xml.wss.filter.ExportTimestampFilter;
import com.sun.xml.wss.filter.ImportTimestampFilter;
import com.sun.xml.wss.impl.DefaultSecurityEnvironmentImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freebxml.omar.common.CredentialInfo;
import org.freebxml.omar.common.security.ExtendedExportCertificateTokenFilter;
import org.freebxml.omar.common.security.ExtendedExportSignatureFilter;
import org.freebxml.omar.common.security.ExtendedImportCertificateTokenFilter;
import org.freebxml.omar.common.security.ExtendedSignFilter;
import org.freebxml.omar.common.security.ExtendedVerifyFilter;
import org.freebxml.omar.common.security.SecurityCallbackHandler;

public class SoapSecurityUtil {
    public static final String BINARY_SECURITY_TOKEN_WSU_ID = "urn:oasis:names:tc:ebxml-regrep:rs:security:SenderCert";
    private static Log log = LogFactory.getLog((Class)(class$org$freebxml$omar$common$security$SoapSecurityUtil == null ? (class$org$freebxml$omar$common$security$SoapSecurityUtil = SoapSecurityUtil.class$("org.freebxml.omar.common.security.SoapSecurityUtil")) : class$org$freebxml$omar$common$security$SoapSecurityUtil));
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static SoapSecurityUtil instance;
    static /* synthetic */ Class class$org$freebxml$omar$common$security$SoapSecurityUtil;

    protected SoapSecurityUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoapSecurityUtil getInstance() {
        if (instance == null) {
            Class clazz = class$org$freebxml$omar$common$security$SoapSecurityUtil == null ? (class$org$freebxml$omar$common$security$SoapSecurityUtil = SoapSecurityUtil.class$("org.freebxml.omar.common.security.SoapSecurityUtil")) : class$org$freebxml$omar$common$security$SoapSecurityUtil;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new SoapSecurityUtil();
                }
            }
        }
        return instance;
    }

    public void signSoapMessage(SOAPMessage msg, CredentialInfo credentialInfo) throws JAXRException {
        try {
            SecurityCallbackHandler cbHandler = new SecurityCallbackHandler(credentialInfo);
            DefaultSecurityEnvironmentImpl se = new DefaultSecurityEnvironmentImpl((CallbackHandler)cbHandler);
            SecurableSoapMessage secureMsg = new SecurableSoapMessage(msg);
            secureMsg.setSecurityEnvironment((SecurityEnvironment)se);
            String wsuId = BINARY_SECURITY_TOKEN_WSU_ID;
            secureMsg.setFilterParameter("x509TokenId", (Object)wsuId);
            DirectReferenceStrategyInfo info = new DirectReferenceStrategyInfo();
            info.setInitializationParameter("forsigning", "true");
            info.setInitializationParameter("alias", credentialInfo.alias);
            KeyInfoStrategy keyInfoStrategy = info.createStrategy();
            ArrayList<Target> targets = new ArrayList<Target>();
            targets.add(new Target("qname", "{http://schemas.xmlsoap.org/soap/envelope/}Body"));
            targets.add(new Target("xpath", "./env:Envelope/env:Header/wsse:Security/wsu:Timestamp"));
            Iterator it = secureMsg.getAttachments();
            while (it.hasNext()) {
                String contentId = ((AttachmentPart)it.next()).getContentId();
                targets.add(new Target("uri", "cid:" + contentId.substring(1, contentId.length() - 1)));
            }
            ExtendedExportSignatureFilter esf = new ExtendedExportSignatureFilter(keyInfoStrategy, credentialInfo.privateKey.getAlgorithm());
            esf.setParameter("x509TokenId", wsuId);
            esf.init();
            esf.process(secureMsg);
            ExtendedExportCertificateTokenFilter eectf = new ExtendedExportCertificateTokenFilter(credentialInfo.alias, wsuId);
            eectf.init();
            eectf.process(secureMsg);
            long now = System.currentTimeMillis();
            TimeZone tzCur = TimeZone.getDefault();
            Date createdDate = new Date(now - (long)tzCur.getOffset(now));
            String createdString = dateFormatter.format(createdDate);
            ExportTimestampFilter etf = new ExportTimestampFilter(createdString);
            etf.process(secureMsg);
            ExtendedSignFilter sf = new ExtendedSignFilter(targets, keyInfoStrategy);
            sf.setParameter("x509TokenId", wsuId);
            sf.setParameter("strtransformxpath", "./env:Envelope/env:Header/wsse:Security/ds:Signature[1]/ds:KeyInfo/wsse:SecurityTokenReference");
            sf.init();
            sf.process(secureMsg);
        }
        catch (Exception e) {
            throw new JAXRException("signSoapMessage failed", (Throwable)e);
        }
    }

    public boolean verifySoapMessage(SOAPMessage msg, CredentialInfo credentialInfo) throws JAXRException {
        try {
            SecurityCallbackHandler cbHandler = new SecurityCallbackHandler(credentialInfo);
            DefaultSecurityEnvironmentImpl se = new DefaultSecurityEnvironmentImpl((CallbackHandler)cbHandler);
            SecurableSoapMessage secureMsg = new SecurableSoapMessage(msg);
            secureMsg.setSecurityEnvironment((SecurityEnvironment)se);
            SecurityHeader secHeader = secureMsg.findSecurityHeader();
            if (secHeader == null) {
                return false;
            }
            ImportTimestampFilter itf = new ImportTimestampFilter();
            itf.process(secureMsg);
            ExtendedImportCertificateTokenFilter ictf = new ExtendedImportCertificateTokenFilter();
            ictf.process(secureMsg);
            credentialInfo.cert = ictf.getLastCert();
            ExtendedVerifyFilter vf = new ExtendedVerifyFilter();
            vf.enableOperationsLog(true);
            vf.process(secureMsg);
            return true;
        }
        catch (Exception e) {
            throw new JAXRException("verifySoapMessage failed", (Throwable)e);
        }
    }

    public static String convertContentIdToUUID(String cid) throws RegistryException {
        if (cid.charAt(0) != '<' || cid.charAt(cid.length() - 1) != '>') {
            throw new RegistryException("Cannot handle attachment. Expecting CID URI. Got: " + cid);
        }
        String uuid = cid.substring(1, cid.length() - 1);
        return uuid;
    }

    public static String convertUUIDToContentId(String uuid) {
        String cid = "<" + uuid + ">";
        return cid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

